/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelVariant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/WatchFaceForAndroidXDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitMetaData", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "metaData", "Lorg/w3c/dom/Element;", "visitElement", "element", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nWatchFaceForAndroidXDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WatchFaceForAndroidXDetector.kt\ncom/android/tools/lint/checks/WatchFaceForAndroidXDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class WatchFaceForAndroidXDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    public static final String WATCH_FACE_META_DATA_NAME = "com.google.android.wearable.watchface.wearableConfigurationAction";
    @NotNull
    public static final String WATCH_FACE_EDITOR_ACTION = "androidx.wear.watchface.editor.action.WATCH_FACE_EDITOR";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"meta-data");
    }

    /*
     * WARNING - void declaration
     */
    private final void visitMetaData(XmlContext context, Element metaData) {
        block4: {
            Attr attr;
            Element element;
            Issue issue;
            XmlContext xmlContext;
            LintFix fix2;
            block6: {
                block5: {
                    void it;
                    LintModelLibrary lintModelLibrary;
                    LintModelAndroidArtifact lintModelAndroidArtifact;
                    if (!Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)WATCH_FACE_META_DATA_NAME) || Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "value"), (Object)WATCH_FACE_EDITOR_ACTION)) break block4;
                    LintModelVariant lintModelVariant = context.getProject().getBuildVariant();
                    if (lintModelVariant == null || (lintModelAndroidArtifact = lintModelVariant.getMainArtifact()) == null || (lintModelLibrary = lintModelAndroidArtifact.findCompileDependency("androidx.wear.watchface:watchface")) == null) {
                        return;
                    }
                    fix2 = this.fix().set().attribute("value").value(WATCH_FACE_EDITOR_ACTION).android().build();
                    xmlContext = context;
                    issue = ISSUE;
                    element = metaData;
                    attr = metaData.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "value");
                    if (attr == null) break block5;
                    Attr attr2 = attr;
                    Element element2 = element;
                    Issue issue2 = issue;
                    XmlContext xmlContext2 = xmlContext;
                    boolean bl = false;
                    Location location = context.getValueLocation((Attr)it);
                    xmlContext = xmlContext2;
                    issue = issue2;
                    element = element2;
                    Location location2 = location;
                    attr = location2;
                    if (location2 != null) break block6;
                }
                attr = context.getLocation((Node)metaData);
            }
            LintFix lintFix = fix2;
            String string2 = "Watch face configuration action must be set to WATCH_FACE_EDITOR for an AndroidX watch face";
            Attr attr3 = attr;
            Element element3 = element;
            Issue issue3 = issue;
            xmlContext.report(new Incident(issue3, (Object)element3, (Location)attr3, string2, lintFix));
        }
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"meta-data")) {
            this.visitMetaData(context, element);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(WatchFaceForAndroidXDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"WatchFaceForAndroidX", (String)"AndroidX watch faces must use action `WATCH_FACE_EDITOR`", (String)"\n                If the package depends on `androidx.wear:wear-watchface`, \\\n                and an AndroidX watch face declares the `wearableConfigurationAction` metadata, \\\n                its value should be `androidx.wear.watchface.editor.action.WATCH_FACE_EDITOR`.\n            ", (Implementation)implementation, (String)"https://developer.android.com/training/wearables/watch-faces/configuration", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/WatchFaceForAndroidXDetector$Issues;", "", "<init>", "()V", "WATCH_FACE_META_DATA_NAME", "", "WATCH_FACE_EDITOR_ACTION", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

