/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.BroadcastReceiverUtils;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u0003:\u00029:B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0012\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010+\u001a\u00020\u00132\u0006\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020&J\u0018\u0010-\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\bH\u0002J\u001c\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\n\u00100\u001a\u000601R\u00020\u0000H\u0002J\u0010\u00102\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0014H\u0016J\u0018\u00103\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u00104\u001a\u000205H\u0016J\"\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u000208H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "registerReceiverMethods", "", "", "getApplicableMethodNames", "applicableSuperClasses", "getApplicableElements", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "isComponentExported", "", "Lcom/android/tools/lint/detector/api/Context;", "root", "incidentComponent", "getProtectedComponent", "component", "isProbablyProtectedBySignaturePermission", "permission", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "isParseUnsafeUri", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "call", "isUnParcellingIntentMethods", "isUnParcellingStringMethods", "processRuntimeReceiver", "isRuntimeReceiverProtected", "javaEvaluator", "storeUnprotectedComponents", "unprotectedComponentName", "reportIncident", "visitor", "Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker;", "afterCheckRootProject", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "reportIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "IntentLaunchChecker", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nUnsafeIntentLaunchDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeIntentLaunchDetector.kt\ncom/android/tools/lint/checks/UnsafeIntentLaunchDetector\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,826:1\n171#2:827\n171#2:830\n1310#3,2:828\n1#4:831\n*S KotlinDebug\n*F\n+ 1 UnsafeIntentLaunchDetector.kt\ncom/android/tools/lint/checks/UnsafeIntentLaunchDetector\n*L\n158#1:827\n165#1:830\n164#1:828,2\n*E\n"})
public final class UnsafeIntentLaunchDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> registerReceiverMethods = BroadcastReceiverUtils.INSTANCE.getBROADCAST_RECEIVER_METHOD_NAMES();
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final int RECEIVER_NOT_EXPORTED = 4;
    @NotNull
    private static final String KEY_UNPROTECTED = "unprotected";
    @NotNull
    private static final String KEY_INCIDENTS = "incidents";
    @NotNull
    private static final String KEY_INCIDENT_CLASS = "incidentClass";
    @NotNull
    private static final String KEY_LOCATION = "location";
    @NotNull
    private static final String KEY_SECONDARY_LOCATION = "secondaryLocation";
    @NotNull
    private static final String CONTEXT_CLASS = "android.content.Context";
    @NotNull
    private static final String ACTIVITY_CLASS = "android.app.Activity";
    @NotNull
    private static final String SERVICE_CLASS = "android.app.Service";
    @NotNull
    private static final String BROADCAST_RECEIVER_CLASS = "android.content.BroadcastReceiver";
    @NotNull
    private static final String PENDING_INTENT_CLASS = "android.app.PendingIntent";
    @NotNull
    private static final String INTENT_CLASS = "android.content.Intent";
    @NotNull
    private static final String BUNDLE_CLASS = "android.os.Bundle";
    @NotNull
    private static final String INTENT_COMPAT_CLASS = "androidx.core.content.IntentCompat";
    @NotNull
    private static final String BUNDLE_COMPAT_CLASS = "androidx.core.os.BundleCompat";
    @NotNull
    private static final String CONTEXT_COMPAT_CLASS = "androidx.core.content.ContextCompat";
    @NotNull
    private static final String ACTIVITY_COMPAT_CLASS = "androidx.core.app.ActivityCompat";
    private static final int MAX_CALL_DEPTH = 3;
    @NotNull
    private static final Map<String, String[]> UNSAFE_INTENT_AS_PARAMETER_METHODS;
    @NotNull
    private static final List<String> ACTIVITY_INTENT_LAUNCH_METHODS;
    @NotNull
    private static final List<String> PENDING_INTENT_LAUNCH_METHODS;
    @NotNull
    private static final String[] INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF;
    @NotNull
    private static final List<String> KNOWN_NORMAL_PERMISSIONS;

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"getParcelableExtra", "getParcelable", "getIntent", "parseUri"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)this.registerReceiverMethods);
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{ACTIVITY_CLASS, BROADCAST_RECEIVER_CLASS, SERVICE_CLASS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "service", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string2 = this.getProtectedComponent((Context)context, element);
        if (string2 == null) {
            return;
        }
        this.storeUnprotectedComponents((Context)context, string2);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isComponentExported(Context context, Element root, String incidentComponent) {
        v0 = DomExtensions.subtag((Element)root, (String)"application");
        if (v0 == null) {
            return false;
        }
        application = v0;
        var5_5 = DomExtensions.iterator((Element)application);
        block5: while (var5_5.hasNext()) {
            component = (Element)var5_5.next();
            var7_7 = component.getTagName();
            if (var7_7 == null) continue;
            switch (var7_7.hashCode()) {
                case -1655966961: {
                    if (!var7_7.equals("activity")) {
                        continue block5;
                    }
                    ** GOTO lbl21
                }
                case -808719889: {
                    if (!var7_7.equals("receiver")) {
                        continue block5;
                    }
                    ** GOTO lbl21
                }
                case 1984153269: {
                    if (!var7_7.equals("service")) continue block5;
lbl21:
                    // 3 sources

                    if (!Intrinsics.areEqual((Object)incidentComponent, (Object)this.getProtectedComponent(context, component))) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private final String getProtectedComponent(Context context, Element component) {
        block6: {
            String permission;
            block5: {
                String exportedAttr = component.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
                if (Intrinsics.areEqual((Object)"true", (Object)exportedAttr)) break block5;
                Intrinsics.checkNotNull((Object)exportedAttr);
                if (!(((CharSequence)exportedAttr).length() == 0) || component.getElementsByTagName("intent-filter").getLength() <= 0) break block6;
            }
            if (!this.isProbablyProtectedBySignaturePermission(permission = component.getAttributeNS("http://schemas.android.com/apk/res/android", "permission"))) {
                Object componentName = component.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                String string2 = componentName;
                Intrinsics.checkNotNull((Object)string2);
                if (StringsKt.startsWith$default((String)string2, (String)".", (boolean)false, (int)2, null)) {
                    componentName = context.getProject().getPackage() + (String)componentName;
                }
                return componentName;
            }
        }
        return null;
    }

    private final boolean isProbablyProtectedBySignaturePermission(String permission) {
        CharSequence charSequence = permission;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !KNOWN_NORMAL_PERMISSIONS.contains(permission);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.extendsClass(declaration.getJavaPsi(), ACTIVITY_CLASS, true)) {
            stringArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(ACTIVITY_CLASS);
        } else if (evaluator.extendsClass(declaration.getJavaPsi(), SERVICE_CLASS, true)) {
            stringArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(SERVICE_CLASS);
        } else {
            if (!evaluator.extendsClass(declaration.getJavaPsi(), BROADCAST_RECEIVER_CLASS, true)) return;
            stringArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(BROADCAST_RECEIVER_CLASS);
        }
        if (stringArray == null) {
            return;
        }
        String[] methodNames = stringArray;
        int n = 0;
        int n2 = methodNames.length;
        while (n < n2) {
            PsiMethod[] psiMethodArray;
            String methodName = methodNames[n];
            Intrinsics.checkNotNullExpressionValue((Object)declaration.getJavaPsi().findMethodsByName(methodName, false), (String)"findMethodsByName(...)");
            for (PsiMethod psiMethod : psiMethodArray) {
                UParameter intentParam;
                void $this$toUElementOfType$iv;
                void element$iv;
                PsiElement $this$firstOrNull$iv;
                UMethod method;
                block10: {
                    PsiElement $this$toUElementOfType$iv2 = (PsiElement)psiMethod;
                    boolean $i$f$toUElementOfType22 = false;
                    method = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv2, UMethod.class);
                    if (method == null) return;
                    PsiMethod $i$f$toUElementOfType22 = method.getJavaPsi();
                    if ($i$f$toUElementOfType22 == null) return;
                    PsiParameterList psiParameterList = $i$f$toUElementOfType22.getParameterList();
                    if (psiParameterList == null) return;
                    PsiParameter[] psiParameterArray = psiParameterList.getParameters();
                    if (psiParameterArray == null) return;
                    PsiParameter[] psiParameterArray2 = psiParameterArray;
                    boolean $i$f$firstOrNull = false;
                    int n3 = 0;
                    int n4 = ((void)$this$firstOrNull$iv).length;
                    while (n3 < n4) {
                        void it = element$iv = $this$firstOrNull$iv[n3];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getCanonicalText(), (Object)INTENT_CLASS)) {
                            ++n3;
                            continue;
                        }
                        break block10;
                    }
                    return;
                }
                Object v1 = element$iv;
                Object var17_19 = v1;
                if (var17_19 == null) return;
                $this$firstOrNull$iv = var17_19;
                boolean $i$f$toUElementOfType = false;
                UParameter uParameter = (UParameter)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UParameter.class);
                UParameter uParameter2 = intentParam = uParameter;
                if (uParameter2 == null) {
                    return;
                }
                Object[] objectArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(BROADCAST_RECEIVER_CLASS);
                IntentLaunchChecker visitor2 = new IntentLaunchChecker(this, SetsKt.setOf(uParameter2), context, Context.getLocation$default((Context)((Context)context), (Object)intentParam.getSourcePsi(), null, (int)2, null), null, false, false, false, 0, objectArray != null ? ArraysKt.contains((Object[])objectArray, (Object)methodName) : false, 248, null);
                method.accept((UastVisitor)visitor2);
                if (!visitor2.getLaunched()) continue;
                this.reportIncident((Context)context, visitor2);
            }
            ++n;
        }
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (this.registerReceiverMethods.contains(method.getName()) && JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)CONTEXT_CLASS, (boolean)false, (int)4, null)) {
            this.processRuntimeReceiver(context, node, method);
        } else if (this.isUnParcellingIntentMethods(evaluator, method) | this.isParseUnsafeUri(evaluator, node, method)) {
            UMethod containingMethod;
            IntentLaunchChecker visitor2 = new IntentLaunchChecker(this, SetsKt.setOf((Object)node), context, context.getLocation((UElement)node), null, false, false, false, 0, false, 504, null);
            UMethod uMethod = containingMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod != null) {
                uMethod.accept((UastVisitor)visitor2);
            }
            if (visitor2.getLaunched()) {
                if (visitor2.getUnprotectedReceiver()) {
                    this.reportIssue((Context)context, null, visitor2.getLocation());
                } else {
                    this.reportIncident((Context)context, visitor2);
                }
            }
        }
    }

    private final boolean isParseUnsafeUri(JavaEvaluator evaluator, UCallExpression call2, PsiMethod method) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"parseUri") && evaluator.isMemberInClass((PsiMember)method, INTENT_CLASS)) {
            UExpression getUriStringCall;
            UExpression uExpression;
            UExpression intentArg;
            UExpression uExpression2 = call2.getArgumentForParameter(0);
            Object object = intentArg = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
            if (intentArg instanceof USimpleNameReferenceExpression) {
                PsiElement psiElement = ((USimpleNameReferenceExpression)intentArg).resolve();
                PsiVariable psiVariable = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
                if (psiVariable == null) {
                    return false;
                }
                uExpression = UastLintUtils.Companion.findLastAssignment(psiVariable, (UElement)call2);
            } else {
                uExpression = intentArg;
            }
            UExpression uExpression3 = getUriStringCall = uExpression;
            UElement uElement = uExpression3 != null ? UastLintUtilsKt.findSelector((UElement)((UElement)uExpression3)) : null;
            UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
            if (uCallExpression == null || (uCallExpression = uCallExpression.resolve()) == null) {
                return false;
            }
            UCallExpression getUriStringMethod = uCallExpression;
            return this.isUnParcellingStringMethods(evaluator, (PsiMethod)getUriStringMethod);
        }
        return false;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnParcellingIntentMethods(JavaEvaluator evaluator, PsiMethod method) {
        block6: {
            String string2 = method.getName();
            switch (string2.hashCode()) {
                case 1712857305: {
                    if (string2.equals("getParcelable")) break;
                    return false;
                }
                case 512252306: {
                    if (!string2.equals("getIntent")) {
                        return false;
                    }
                    break block6;
                }
                case -1169415497: {
                    if (!string2.equals("getParcelableExtra")) return false;
                    if (JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)INTENT_CLASS, (boolean)false, (int)4, null)) return true;
                    if (!evaluator.isMemberInClass((PsiMember)method, INTENT_COMPAT_CLASS)) return false;
                    return true;
                }
            }
            if (JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)BUNDLE_CLASS, (boolean)false, (int)4, null)) return true;
            if (!evaluator.isMemberInClass((PsiMember)method, BUNDLE_COMPAT_CLASS)) return false;
            return true;
            return false;
        }
        boolean bl = JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)CONTEXT_CLASS, (boolean)false, (int)4, null);
        return bl;
    }

    private final boolean isUnParcellingStringMethods(JavaEvaluator evaluator, PsiMethod method) {
        return Intrinsics.areEqual((Object)method.getName(), (Object)"getStringExtra") && JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)INTENT_CLASS, (boolean)false, (int)4, null) || Intrinsics.areEqual((Object)method.getName(), (Object)"getString") && JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)BUNDLE_CLASS, (boolean)false, (int)4, null);
    }

    private final void processRuntimeReceiver(JavaContext context, UCallExpression call2, PsiMethod method) {
        UExpression uExpression = UastLintUtils.Companion.findArgument(call2, method, BROADCAST_RECEIVER_CLASS);
        if (uExpression == null) {
            return;
        }
        UExpression receiverArg = uExpression;
        if (UastLiteralUtils.isNullLiteral((UElement)((UElement)receiverArg))) {
            return;
        }
        if (!this.isRuntimeReceiverProtected(call2, method, context.getEvaluator())) {
            UCallExpression receiverConstructor;
            UCallExpression uCallExpression = receiverConstructor = UastLintUtils.Companion.findConstruction(BROADCAST_RECEIVER_CLASS, receiverArg, (UElement)call2, true);
            String string2 = UastUtils.getQualifiedName((UReferenceExpression)(uCallExpression != null ? uCallExpression.getClassReference() : null));
            if (string2 == null) {
                return;
            }
            String unprotectedReceiverClassName = string2;
            this.storeUnprotectedComponents((Context)context, unprotectedReceiverClassName);
        }
    }

    public final boolean isRuntimeReceiverProtected(@NotNull UCallExpression call2, @NotNull PsiMethod method, @NotNull JavaEvaluator javaEvaluator) {
        String permission;
        Integer flags;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)javaEvaluator, (String)"javaEvaluator");
        UExpression flagsArg = UastLintUtils.Companion.findArgument(call2, method, "int");
        ConstantEvaluator evaluator = new ConstantEvaluator().allowFieldInitializers();
        Object object = evaluator.evaluate((UElement)flagsArg);
        Integer n = flags = object instanceof Integer ? (Integer)object : null;
        if (flags != null && (flags & 4) != 0) {
            return true;
        }
        UExpression permissionArg = UastLintUtils.Companion.findArgument(call2, method, "java.lang.String");
        Object object2 = evaluator.evaluate((UElement)permissionArg);
        String string2 = permission = object2 instanceof String ? (String)object2 : null;
        if (this.isProbablyProtectedBySignaturePermission(permission)) {
            return true;
        }
        UExpression uExpression = UastLintUtils.Companion.findArgument(call2, method, "android.content.IntentFilter");
        if (uExpression == null) {
            return true;
        }
        UExpression filterArg = uExpression;
        boolean isProtected2 = (Boolean)BroadcastReceiverUtils.checkIsProtectedReceiverAndReturnUnprotectedActions(filterArg, call2, javaEvaluator).component1();
        return isProtected2;
    }

    private final void storeUnprotectedComponents(Context context, String unprotectedComponentName) {
        LintMap lintMap = context.getPartialResults(ISSUE).map();
        LintMap lintMap2 = lintMap.getMap(KEY_UNPROTECTED);
        if (lintMap2 == null) {
            LintMap lintMap3;
            LintMap it = lintMap3 = this.map();
            boolean bl = false;
            lintMap.put(KEY_UNPROTECTED, it);
            lintMap2 = lintMap3;
        }
        LintMap unprotectedComponents = lintMap2;
        unprotectedComponents.put(unprotectedComponentName, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportIncident(Context context, IntentLaunchChecker visitor2) {
        if (context.isGlobalAnalysis()) {
            String incidentComponent = visitor2.getIncidentClass();
            Node node = context.getMainProject().getMergedManifest();
            if (node == null || (node = node.getDocumentElement()) == null) {
                return;
            }
            if (this.isComponentExported(context, (Element)node, incidentComponent)) {
                this.reportIssue(context, incidentComponent, visitor2.getLocation());
            }
        } else {
            void $this$reportIncident_u24lambda_u241;
            LintMap lintMap;
            LintMap lintMap2;
            LintMap lintMap3 = context.getPartialResults(ISSUE).map();
            LintMap lintMap4 = lintMap3.getMap(KEY_INCIDENTS);
            if (lintMap4 == null) {
                LintMap it = lintMap2 = this.map();
                boolean bl = false;
                lintMap3.put(KEY_INCIDENTS, it);
                lintMap4 = lintMap2;
            }
            LintMap incidents = lintMap4;
            lintMap2 = lintMap = this.map();
            String string2 = String.valueOf(incidents.getSize());
            LintMap lintMap5 = incidents;
            boolean bl = false;
            $this$reportIncident_u24lambda_u241.put(KEY_LOCATION, visitor2.getLocation());
            Location location = visitor2.getLocation().getSecondary();
            if (location == null) {
                return;
            }
            $this$reportIncident_u24lambda_u241.put(KEY_SECONDARY_LOCATION, location);
            String string3 = visitor2.getIncidentClass();
            if (string3 == null) {
                return;
            }
            $this$reportIncident_u24lambda_u241.put(KEY_INCIDENT_CLASS, string3);
            Unit unit = Unit.INSTANCE;
            lintMap5.put(string2, lintMap);
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(ISSUE));
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        LintMap lintMap = partialResults.map().getMap(KEY_INCIDENTS);
        if (lintMap == null) {
            return;
        }
        LintMap incidents = lintMap;
        LintMap lintMap2 = partialResults.map().getMap(KEY_UNPROTECTED);
        if (lintMap2 == null) {
            return;
        }
        LintMap unprotectedComponents = lintMap2;
        for (String key : incidents) {
            Location location;
            Object incidentComponent;
            LintMap incidentMap = incidents.getMap(key);
            Object object = incidentMap;
            if (object == null) continue;
            if ((object = object.get(KEY_INCIDENT_CLASS)) == null || !unprotectedComponents.containsKey((String)(incidentComponent = object)) || incidentMap.getLocation(KEY_LOCATION) == null) continue;
            location.setSecondary(incidentMap.getLocation(KEY_SECONDARY_LOCATION));
            this.reportIssue(context, (String)incidentComponent, location);
        }
    }

    private final void reportIssue(Context context, String incidentComponent, Location location) {
        CharSequence charSequence = incidentComponent;
        Object component = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : " " + incidentComponent;
        String message2 = StringsKt.trimIndent((String)("\n          This intent could be coming from an untrusted source. It is later launched by \\\n          an unprotected component" + (String)component + ". You could either make the component" + (String)component + " \\\n          protected; or sanitize this intent using androidx.core.content.IntentSanitizer.\n      "));
        context.report(new Incident(ISSUE, location, message2));
    }

    public static final /* synthetic */ List access$getRegisterReceiverMethods$p(UnsafeIntentLaunchDetector $this) {
        return $this.registerReceiverMethods;
    }

    static {
        Object[] objectArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(UnsafeIntentLaunchDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), (EnumSet[])objectArray);
        objectArray = Issue.Companion;
        String[] stringArray = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"UnsafeIntentLaunch", (String)"Launched Unsafe Intent", (String)"\n                    Intent that potentially could come from an untrusted source should not be \\\n                    launched from an unprotected component without first being sanitized. See \\\n                    this support FAQ for details: https://support.google.com/faqs/answer/9267555\n                    ", (Implementation)implementation, null, (Category)stringArray, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = new Pair[3];
        stringArray = new String[]{"onReceive"};
        objectArray[0] = TuplesKt.to((Object)BROADCAST_RECEIVER_CLASS, (Object)stringArray);
        stringArray = new String[]{"onNewIntent", "onActivityResult", "onActivityReenter"};
        objectArray[1] = TuplesKt.to((Object)ACTIVITY_CLASS, (Object)stringArray);
        stringArray = new String[]{"onBind", "onUnbind", "onRebind", "onTaskRemoved", "onStartCommand", "onStart"};
        objectArray[2] = TuplesKt.to((Object)SERVICE_CLASS, (Object)stringArray);
        UNSAFE_INTENT_AS_PARAMETER_METHODS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"createPendingResult", "navigateUpTo", "navigateUpToFromChild", "startActivityIfNeeded", "startActivityForResult", "startActivityFromChild", "startActivityFromFragment", "startIntentSender", "startIntentSenderFromChild", "startIntentSenderForResult", "startNextMatchingActivity", "setResult"};
        ACTIVITY_INTENT_LAUNCH_METHODS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"getActivity", "getBroadcast", "getService", "getForegroundService"};
        PENDING_INTENT_LAUNCH_METHODS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"cloneFilter", "getOriginalIntent", "getSelector", "getParcelableExtra"};
        INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF = objectArray;
        objectArray = new String[]{"android.permission.READ_BASIC_PHONE_STATE", "android.permission.MANAGE_OWN_CALLS", "android.permission.CALL_COMPANION_APP", "android.permission.HIGH_SAMPLING_RATE_SENSORS", "android.permission.USE_FINGERPRINT", "android.permission.USE_BIOMETRIC", "android.permission.READ_PROFILE", "android.permission.WRITE_PROFILE", "android.permission.READ_SOCIAL_STREAM", "android.permission.WRITE_SOCIAL_STREAM", "android.permission.READ_USER_DICTIONARY", "android.permission.WRITE_USER_DICTIONARY", "android.permission.WRITE_SMS", "com.android.browser.permission.READ_HISTORY_BOOKMARKS", "com.android.browser.permission.WRITE_HISTORY_BOOKMARKS", "android.permission.AUTHENTICATE_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS", "android.permission.USE_CREDENTIALS", "android.permission.SUBSCRIBED_FEEDS_READ", "android.permission.SUBSCRIBED_FEEDS_WRITE", "android.permission.FLASHLIGHT", "com.android.alarm.permission.SET_ALARM", "android.permission.ACCESS_LOCATION_EXTRA_COMMANDS", "android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN", "android.permission.NFC", "android.permission.NFC_TRANSACTION_EVENT", "android.permission.NFC_PREFERRED_PAYMENT_INFO", "android.permission.CHANGE_WIFI_MULTICAST_STATE", "android.permission.VIBRATE", "android.permission.WAKE_LOCK", "android.permission.TRANSMIT_IR", "android.permission.TURN_SCREEN_ON", "android.permission.MODIFY_AUDIO_SETTINGS", "android.permission.DISABLE_KEYGUARD", "android.permission.REQUEST_PASSWORD_COMPLEXITY", "android.permission.GET_TASKS", "android.permission.REORDER_TASKS", "android.permission.RESTART_PACKAGES", "android.permission.KILL_BACKGROUND_PROCESSES", "android.permission.REQUEST_COMPANION_RUN_IN_BACKGROUND", "android.permission.REQUEST_COMPANION_START_FOREGROUND_SERVICES_FROM_BACKGROUND", "android.permission.REQUEST_COMPANION_USE_DATA_IN_BACKGROUND", "android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.HIDE_OVERLAY_WINDOWS", "android.permission.SET_WALLPAPER", "android.permission.SET_WALLPAPER_HINTS", "android.permission.EXPAND_STATUS_BAR", "com.android.launcher.permission.INSTALL_SHORTCUT", "com.android.launcher.permission.UNINSTALL_SHORTCUT", "android.permission.READ_SYNC_SETTINGS", "android.permission.WRITE_SYNC_SETTINGS", "android.permission.READ_SYNC_STATS", "android.permission.PERSISTENT_ACTIVITY", "android.permission.GET_PACKAGE_SIZE", "android.permission.RECEIVE_BOOT_COMPLETED", "android.permission.BROADCAST_STICKY", "android.permission.CHANGE_NETWORK_STATE", "android.permission.SCHEDULE_EXACT_ALARM", "android.permission.USE_EXACT_ALARM", "android.permission.REQUEST_DELETE_PACKAGES", "android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE", "android.permission.DELIVER_COMPANION_MESSAGES", "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", "android.permission.ACCESS_NOTIFICATION_POLICY", "android.permission.READ_INSTALL_SESSIONS", "android.permission.FOREGROUND_SERVICE", "android.permission.USE_FULL_SCREEN_INTENT", "android.permission.QUERY_ALL_PACKAGES", "android.permission.READ_NEARBY_STREAMING_POLICY", "android.permission.UPDATE_PACKAGES_WITHOUT_USER_ACTION"};
        KNOWN_NORMAL_PERMISSIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "RECEIVER_NOT_EXPORTED", "", "KEY_UNPROTECTED", "", "KEY_INCIDENTS", "KEY_INCIDENT_CLASS", "KEY_LOCATION", "KEY_SECONDARY_LOCATION", "CONTEXT_CLASS", "ACTIVITY_CLASS", "SERVICE_CLASS", "BROADCAST_RECEIVER_CLASS", "PENDING_INTENT_CLASS", "INTENT_CLASS", "BUNDLE_CLASS", "INTENT_COMPAT_CLASS", "BUNDLE_COMPAT_CLASS", "CONTEXT_COMPAT_CLASS", "ACTIVITY_COMPAT_CLASS", "MAX_CALL_DEPTH", "UNSAFE_INTENT_AS_PARAMETER_METHODS", "", "", "ACTIVITY_INTENT_LAUNCH_METHODS", "", "PENDING_INTENT_LAUNCH_METHODS", "INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF", "[Ljava/lang/String;", "KNOWN_NORMAL_PERMISSIONS", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001LBc\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u0002022\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u0004H\u0016J\u0012\u00104\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u000106H\u0002J \u00107\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u0004H\u0002J \u00108\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u0004H\u0002J\u0018\u00109\u001a\u00020\f2\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u0004H\u0002J\u001a\u0010:\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u0010;\u001a\u00020\u0004H\u0002J\u0014\u0010<\u001a\u0004\u0018\u0001002\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u0010=\u001a\u0002022\u0006\u00105\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u0010B\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0002J\u0018\u0010E\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0002J\u0018\u0010F\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0002J\u0018\u0010G\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010H\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0002J\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u000206H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010!\"\u0004\b%\u0010#R\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010!\"\u0004\b'\u0010#R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010!\"\u0004\b-\u0010#\u00a8\u0006M"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "initial", "", "Lorg/jetbrains/uast/UElement;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "location", "Lcom/android/tools/lint/detector/api/Location;", "incidentClass", "", "launched", "", "returned", "unprotectedReceiver", "resolveCallDepth", "", "checkProtectedBroadcast", "<init>", "(Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector;Ljava/util/Collection;Lcom/android/tools/lint/detector/api/JavaContext;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;ZZZIZ)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "setContext", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getLocation", "()Lcom/android/tools/lint/detector/api/Location;", "setLocation", "(Lcom/android/tools/lint/detector/api/Location;)V", "getIncidentClass", "()Ljava/lang/String;", "setIncidentClass", "(Ljava/lang/String;)V", "getLaunched", "()Z", "setLaunched", "(Z)V", "getReturned", "setReturned", "getUnprotectedReceiver", "setUnprotectedReceiver", "getResolveCallDepth", "()I", "setResolveCallDepth", "(I)V", "getCheckProtectedBroadcast", "setCheckProtectedBroadcast", "returnsSelf", "call", "Lorg/jetbrains/uast/UCallExpression;", "argument", "", "reference", "isProtectedBroadcastAction", "expression", "Lorg/jetbrains/uast/UExpression;", "inProtectedBroadcastBranch", "inProtectedBroadcastIfBranch", "inProtectedBroadcastSwitchCase", "isIntentAction", "intentRef", "findIntentActionAssignmentCall", "returns", "Lorg/jetbrains/uast/UReturnExpression;", "isIntentLaunchedBySystem", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "isIntentLaunchedByContextMethods", "method", "Lcom/intellij/psi/PsiMethod;", "isIntentLaunchedByActivityMethods", "isIntentLaunchedByBroadcastReceiver", "isIntentLaunchedByPendingIntentMethods", "handleAnonymousBroadcastReceiver", "getThisExpression", "Lorg/jetbrains/uast/UThisExpression;", "block", "ReturnsTracker", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nUnsafeIntentLaunchDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeIntentLaunchDetector.kt\ncom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,826:1\n171#2:827\n18#3:828\n18#3:829\n18#3:830\n18#3:831\n18#3:832\n*S KotlinDebug\n*F\n+ 1 UnsafeIntentLaunchDetector.kt\ncom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker\n*L\n423#1:827\n471#1:828\n496#1:829\n505#1:830\n508#1:831\n513#1:832\n*E\n"})
    private final class IntentLaunchChecker
    extends DataFlowAnalyzer {
        @NotNull
        private JavaContext context;
        @NotNull
        private Location location;
        @Nullable
        private String incidentClass;
        private boolean launched;
        private boolean returned;
        private boolean unprotectedReceiver;
        private int resolveCallDepth;
        private boolean checkProtectedBroadcast;
        final /* synthetic */ UnsafeIntentLaunchDetector this$0;

        public IntentLaunchChecker(@NotNull UnsafeIntentLaunchDetector this$0, @NotNull Collection<? extends UElement> initial, @NotNull JavaContext context, @Nullable Location location, String incidentClass, boolean launched, boolean returned, boolean unprotectedReceiver, int resolveCallDepth, boolean checkProtectedBroadcast) {
            Intrinsics.checkNotNullParameter(initial, (String)"initial");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)location, (String)UnsafeIntentLaunchDetector.KEY_LOCATION);
            this.this$0 = this$0;
            super(initial, null, 2, null);
            this.context = context;
            this.location = location;
            this.incidentClass = incidentClass;
            this.launched = launched;
            this.returned = returned;
            this.unprotectedReceiver = unprotectedReceiver;
            this.resolveCallDepth = resolveCallDepth;
            this.checkProtectedBroadcast = checkProtectedBroadcast;
        }

        public /* synthetic */ IntentLaunchChecker(UnsafeIntentLaunchDetector unsafeIntentLaunchDetector, Collection collection, JavaContext javaContext, Location location, String string2, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            if ((n2 & 0x10) != 0) {
                bl = false;
            }
            if ((n2 & 0x20) != 0) {
                bl2 = false;
            }
            if ((n2 & 0x40) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x80) != 0) {
                n = 0;
            }
            if ((n2 & 0x100) != 0) {
                bl4 = false;
            }
            this(unsafeIntentLaunchDetector, collection, javaContext, location, string2, bl, bl2, bl3, n, bl4);
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public final void setContext(@NotNull JavaContext javaContext) {
            Intrinsics.checkNotNullParameter((Object)javaContext, (String)"<set-?>");
            this.context = javaContext;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"<set-?>");
            this.location = location;
        }

        @Nullable
        public final String getIncidentClass() {
            return this.incidentClass;
        }

        public final void setIncidentClass(@Nullable String string2) {
            this.incidentClass = string2;
        }

        public final boolean getLaunched() {
            return this.launched;
        }

        public final void setLaunched(boolean bl) {
            this.launched = bl;
        }

        public final boolean getReturned() {
            return this.returned;
        }

        public final void setReturned(boolean bl) {
            this.returned = bl;
        }

        public final boolean getUnprotectedReceiver() {
            return this.unprotectedReceiver;
        }

        public final void setUnprotectedReceiver(boolean bl) {
            this.unprotectedReceiver = bl;
        }

        public final int getResolveCallDepth() {
            return this.resolveCallDepth;
        }

        public final void setResolveCallDepth(int n) {
            this.resolveCallDepth = n;
        }

        public final boolean getCheckProtectedBroadcast() {
            return this.checkProtectedBroadcast;
        }

        public final void setCheckProtectedBroadcast(boolean bl) {
            this.checkProtectedBroadcast = bl;
        }

        @Override
        public boolean returnsSelf(@NotNull UCallExpression call2) {
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            if (ArraysKt.contains((Object[])INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF, (Object)call2.getMethodName())) {
                PsiType psiType = call2.getReceiverType();
                if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)UnsafeIntentLaunchDetector.INTENT_CLASS)) {
                    return false;
                }
            }
            if (UastLintUtilsKt.isReturningLambdaResult((UCallExpression)call2)) {
                UExpression lambda;
                Iterator iterator = call2.getValueArguments().iterator();
                while (iterator.hasNext() && (lambda = (UExpression)iterator.next()) instanceof ULambdaExpression && (((ULambdaExpression)lambda).getValueParameters().isEmpty() ? (UAnnotated)this.getThisExpression(((ULambdaExpression)lambda).getBody()) : (UAnnotated)((ULambdaExpression)lambda).getValueParameters().get(0)) != null) {
                    UAnnotated tracked;
                    tracked = tracked;
                    ReturnsTracker returnsTracker = new ReturnsTracker(this, this.context, (UElement)tracked, false, 0, 12, null);
                    ((ULambdaExpression)lambda).getBody().accept((UastVisitor)returnsTracker);
                    if (!returnsTracker.getReturned()) continue;
                    return true;
                }
            }
            return super.returnsSelf(call2);
        }

        @Override
        public void argument(@NotNull UCallExpression call2, @NotNull UElement reference) {
            block14: {
                PsiMethod psiMethod;
                block16: {
                    block15: {
                        block13: {
                            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                            if (this.incidentClass == null) {
                                UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)call2), UClass.class, (boolean)false, (int)2, null);
                                String string2 = this.incidentClass = uClass != null ? uClass.getQualifiedName() : null;
                                if (this.incidentClass == null) {
                                    this.unprotectedReceiver = this.handleAnonymousBroadcastReceiver(call2);
                                }
                            }
                            if (!this.isIntentLaunchedBySystem(this.context.getEvaluator(), call2)) break block13;
                            if (!this.checkProtectedBroadcast || !this.inProtectedBroadcastBranch(this.context, call2, reference)) {
                                this.launched = true;
                                this.location.setSecondary(this.context.getLocation((UElement)call2));
                                Location location = this.location.getSecondary();
                                if (location != null) {
                                    location.setMessage("The unsafe intent is launched here.");
                                }
                            }
                            break block14;
                        }
                        if (this.resolveCallDepth > 3) {
                            return;
                        }
                        psiMethod = call2.resolve();
                        if (psiMethod == null) break block15;
                        PsiElement $this$toUElementOfType$iv = (PsiElement)psiMethod;
                        boolean $i$f$toUElementOfType = false;
                        psiMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                        if (psiMethod != null) break block16;
                    }
                    return;
                }
                PsiMethod containingMethod = psiMethod;
                PsiParameter intentParameter = (PsiParameter)this.context.getEvaluator().computeArgumentMapping(call2, containingMethod.getJavaPsi()).get(reference);
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)intentParameter));
                if (uElement == null) {
                    return;
                }
                IntentLaunchChecker visitor2 = new IntentLaunchChecker(this.this$0, SetsKt.setOf((Object)uElement), this.context, this.location, this.incidentClass, false, false, false, this.resolveCallDepth + 1, false, 368, null);
                containingMethod.accept((UastVisitor)visitor2);
                if (visitor2.launched) {
                    this.this$0.reportIncident((Context)this.context, visitor2);
                } else if (visitor2.returned) {
                    this.getInstances().add((UElement)call2);
                }
            }
        }

        private final boolean isProtectedBroadcastAction(UExpression expression) {
            Object object = new ConstantEvaluator().allowFieldInitializers().evaluate((UElement)expression);
            String string2 = object instanceof String ? (String)object : null;
            if (string2 == null) {
                return false;
            }
            String action = string2;
            return BroadcastReceiverUtils.isProtectedBroadcast(action);
        }

        private final boolean inProtectedBroadcastBranch(JavaContext context, UCallExpression call2, UElement reference) {
            return this.inProtectedBroadcastIfBranch(context, call2, reference) || this.inProtectedBroadcastSwitchCase(call2, reference);
        }

        private final boolean inProtectedBroadcastIfBranch(JavaContext context, UCallExpression call2, UElement reference) {
            UElement $this$getParentOfType_u24default$iv = (UElement)call2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UIfExpression ifExp = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv);
            while (ifExp != null) {
                UExpression op1 = null;
                UExpression op2 = null;
                UExpression condition = ifExp.getCondition();
                if (condition instanceof UBinaryExpression && ((UBinaryExpression)condition).getOperator() == UastBinaryOperator.EQUALS) {
                    op1 = ((UBinaryExpression)condition).getLeftOperand();
                    op2 = ((UBinaryExpression)condition).getRightOperand();
                } else if (condition instanceof UQualifiedReferenceExpression) {
                    UCallExpression methodCall;
                    UExpression uExpression = ((UQualifiedReferenceExpression)condition).getSelector();
                    UCallExpression uCallExpression = methodCall = uExpression instanceof UCallExpression ? (UCallExpression)uExpression : null;
                    if (Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getMethodName() : null), (Object)"equals")) {
                        op1 = ((UQualifiedReferenceExpression)condition).getReceiver();
                        op2 = (UExpression)methodCall.getValueArguments().get(0);
                    }
                }
                if (op1 != null && op2 != null && (this.isIntentAction(op1, reference) && this.isProtectedBroadcastAction(op2) || this.isIntentAction(op2, reference) && this.isProtectedBroadcastAction(op1))) {
                    return Context.getLocation$default((Context)((Context)context), (Object)ifExp.getThenExpression(), null, (int)2, null).contains(context.getLocation((UElement)call2));
                }
                UElement $this$getParentOfType_u24default$iv2 = (UElement)ifExp;
                boolean strict$iv2 = true;
                boolean $i$f$getParentOfType2 = false;
                ifExp = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv2, UIfExpression.class, (boolean)strict$iv2);
            }
            return false;
        }

        private final boolean inProtectedBroadcastSwitchCase(UCallExpression call2, UElement reference) {
            UElement $this$getParentOfType_u24default$iv = (UElement)call2;
            boolean strict$iv2 = true;
            boolean $i$f$getParentOfType = false;
            USwitchExpression switchExp = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, USwitchExpression.class, (boolean)strict$iv2);
            while (switchExp != null) {
                UExpression caseValue;
                USwitchClauseExpression caseExpression;
                UExpression strict$iv2 = switchExp.getExpression();
                UReferenceExpression subject = strict$iv2 instanceof UReferenceExpression ? (UReferenceExpression)strict$iv2 : null;
                UElement $this$getParentOfType_u24default$iv2 = (UElement)call2;
                boolean strict$iv32 = true;
                boolean $i$f$getParentOfType2 = false;
                if ((USwitchClauseExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv2, USwitchClauseExpression.class, (boolean)strict$iv32) == null) {
                    return false;
                }
                if ((UExpression)CollectionsKt.firstOrNull((List)caseExpression.getCaseValues()) == null) {
                    return false;
                }
                PsiElement strict$iv32 = caseValue.getSourcePsi();
                PsiSwitchLabelStatementBase psiSwitchLabelStatementBase = strict$iv32 instanceof PsiSwitchLabelStatementBase ? (PsiSwitchLabelStatementBase)strict$iv32 : null;
                boolean bl = psiSwitchLabelStatementBase != null ? psiSwitchLabelStatementBase.isDefaultCase() : false;
                if (bl) {
                    return false;
                }
                if (this.isIntentAction((UExpression)subject, reference) && this.isProtectedBroadcastAction(caseValue)) {
                    return true;
                }
                $this$getParentOfType_u24default$iv2 = (UElement)switchExp;
                strict$iv32 = true;
                $i$f$getParentOfType2 = false;
                switchExp = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv2, USwitchExpression.class, (boolean)strict$iv32);
            }
            return false;
        }

        private final boolean isIntentAction(UExpression expression, UElement intentRef) {
            UCallExpression actionAssignmentCall = this.findIntentActionAssignmentCall(expression);
            UCallExpression uCallExpression = actionAssignmentCall;
            return (uCallExpression != null && (uCallExpression = uCallExpression.getReceiver()) != null && (uCallExpression = UastUtils.skipParenthesizedExprDown((UExpression)uCallExpression)) != null ? UastUtils.tryResolve((UElement)((UElement)uCallExpression)) : null) == UastUtils.tryResolve((UElement)intentRef);
        }

        private final UCallExpression findIntentActionAssignmentCall(UExpression expression) {
            UExpression uExpression;
            PsiElement resolved;
            UExpression actionExpr;
            UExpression uExpression2 = expression;
            UExpression uExpression3 = actionExpr = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
            Object object = resolved = uExpression3 != null ? UastUtils.tryResolve((UElement)((UElement)uExpression3)) : null;
            if (resolved instanceof PsiVariable) {
                UExpression uExpression4 = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)actionExpr);
                if (uExpression4 == null) {
                    return null;
                }
                UExpression assignment = uExpression4;
                return this.findIntentActionAssignmentCall(assignment);
            }
            if (actionExpr instanceof UQualifiedReferenceExpression) {
                UExpression uExpression5 = ((UQualifiedReferenceExpression)actionExpr).getSelector();
                UCallExpression uCallExpression = uExpression5 instanceof UCallExpression ? (UCallExpression)uExpression5 : null;
                if (uCallExpression == null) {
                    return null;
                }
                UCallExpression call2 = uCallExpression;
                return UastLintUtilsKt.isReturningContext((UCallExpression)call2) ? this.findIntentActionAssignmentCall(((UQualifiedReferenceExpression)actionExpr).getReceiver()) : this.findIntentActionAssignmentCall((UExpression)call2);
            }
            PsiMethod psiMethod = resolved instanceof PsiMethod ? (PsiMethod)resolved : null;
            if (psiMethod == null) {
                return null;
            }
            PsiMethod method = psiMethod;
            return Intrinsics.areEqual((Object)"getAction", (Object)method.getName()) ? ((uExpression = actionExpr) instanceof UCallExpression ? (UCallExpression)uExpression : null) : null;
        }

        @Override
        public void returns(@NotNull UReturnExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.returned = true;
        }

        private final boolean isIntentLaunchedBySystem(JavaEvaluator evaluator, UCallExpression call2) {
            PsiMethod psiMethod = call2.resolve();
            if (psiMethod == null) {
                return false;
            }
            PsiMethod method = psiMethod;
            return this.isIntentLaunchedByContextMethods(evaluator, method) || this.isIntentLaunchedByActivityMethods(evaluator, method) || this.isIntentLaunchedByBroadcastReceiver(evaluator, method) || this.isIntentLaunchedByPendingIntentMethods(evaluator, method);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isIntentLaunchedByContextMethods(JavaEvaluator evaluator, PsiMethod method) {
            PsiClass psiClass = method.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)UnsafeIntentLaunchDetector.CONTEXT_CLASS)) return true;
            PsiClass psiClass2 = method.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass2 != null ? psiClass2.getQualifiedName() : null), (Object)UnsafeIntentLaunchDetector.CONTEXT_COMPAT_CLASS)) return true;
            PsiMethod[] psiMethodArray = method.findSuperMethods(evaluator.findClass(UnsafeIntentLaunchDetector.CONTEXT_CLASS));
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            if (((Object[])psiMethodArray).length != 0) return true;
            return false;
        }

        private final boolean isIntentLaunchedByActivityMethods(JavaEvaluator evaluator, PsiMethod method) {
            return ACTIVITY_INTENT_LAUNCH_METHODS.contains(method.getName()) && (JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)UnsafeIntentLaunchDetector.ACTIVITY_CLASS, (boolean)false, (int)4, null) || evaluator.isMemberInClass((PsiMember)method, UnsafeIntentLaunchDetector.ACTIVITY_COMPAT_CLASS));
        }

        private final boolean isIntentLaunchedByBroadcastReceiver(JavaEvaluator evaluator, PsiMethod method) {
            return Intrinsics.areEqual((Object)method.getName(), (Object)"peekService") && JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)evaluator, (PsiMember)((PsiMember)method), (String)UnsafeIntentLaunchDetector.BROADCAST_RECEIVER_CLASS, (boolean)false, (int)4, null);
        }

        private final boolean isIntentLaunchedByPendingIntentMethods(JavaEvaluator evaluator, PsiMethod method) {
            return PENDING_INTENT_LAUNCH_METHODS.contains(method.getName()) && evaluator.isMemberInClass((PsiMember)method, UnsafeIntentLaunchDetector.PENDING_INTENT_CLASS);
        }

        private final boolean handleAnonymousBroadcastReceiver(UCallExpression call2) {
            Ref.BooleanRef result;
            block1: {
                UClass anonymousClass = (UClass)UastUtils.getParentOfType((UElement)((UElement)call2), UClass.class, (boolean)true);
                UClass uClass = anonymousClass;
                if (uClass == null || (uClass = uClass.getUastParent()) == null) {
                    return false;
                }
                UClass parent = uClass;
                result = new Ref.BooleanRef();
                Set set2 = SetsKt.setOf((Object)parent);
                DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(this.this$0, this, result, set2){
                    final /* synthetic */ UnsafeIntentLaunchDetector this$0;
                    final /* synthetic */ IntentLaunchChecker this$1;
                    final /* synthetic */ Ref.BooleanRef $result;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$result = $result;
                        super($super_call_param$1, null, 2, null);
                    }

                    public void argument(UCallExpression call2, UElement reference) {
                        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                        if (CollectionsKt.contains((Iterable)UnsafeIntentLaunchDetector.access$getRegisterReceiverMethods$p(this.this$0), (Object)call2.getMethodName())) {
                            PsiMethod psiMethod = call2.resolve();
                            if (psiMethod == null) {
                                return;
                            }
                            PsiMethod method = psiMethod;
                            if (!this.this$0.isRuntimeReceiverProtected(call2, method, this.this$1.getContext().getEvaluator())) {
                                this.$result.element = true;
                            }
                        }
                    }
                };
                UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)parent, UMethod.class, (boolean)false, (int)2, null);
                if (uMethod == null) break block1;
                uMethod.accept((UastVisitor)visitor2);
            }
            return result.element;
        }

        private final UThisExpression getThisExpression(UExpression block) {
            Ref.ObjectRef result = new Ref.ObjectRef();
            block.accept((UastVisitor)new AbstractUastVisitor((Ref.ObjectRef<UThisExpression>)result){
                final /* synthetic */ Ref.ObjectRef<UThisExpression> $result;
                {
                    this.$result = $result;
                }

                public boolean visitThisExpression(UThisExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.$result.element = node;
                    return super.visitThisExpression(node);
                }
            });
            return (UThisExpression)result.element;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker$ReturnsTracker;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "tracked", "Lorg/jetbrains/uast/UElement;", "returned", "", "resolveCallDepth", "", "<init>", "(Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker;Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UElement;ZI)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "getReturned", "()Z", "setReturned", "(Z)V", "getResolveCallDepth", "()I", "setResolveCallDepth", "(I)V", "returns", "", "expression", "Lorg/jetbrains/uast/UReturnExpression;", "argument", "call", "Lorg/jetbrains/uast/UCallExpression;", "reference", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nUnsafeIntentLaunchDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeIntentLaunchDetector.kt\ncom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker$ReturnsTracker\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,826:1\n171#2:827\n171#2:828\n*S KotlinDebug\n*F\n+ 1 UnsafeIntentLaunchDetector.kt\ncom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker$ReturnsTracker\n*L\n656#1:827\n663#1:828\n*E\n"})
        public final class ReturnsTracker
        extends DataFlowAnalyzer {
            @NotNull
            private final JavaContext context;
            private boolean returned;
            private int resolveCallDepth;
            final /* synthetic */ IntentLaunchChecker this$0;

            public ReturnsTracker(@NotNull IntentLaunchChecker this$0, @NotNull JavaContext context, UElement tracked, boolean returned, int resolveCallDepth) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)tracked, (String)"tracked");
                this.this$0 = this$0;
                super(SetsKt.setOf((Object)tracked), null, 2, null);
                this.context = context;
                this.returned = returned;
                this.resolveCallDepth = resolveCallDepth;
            }

            public /* synthetic */ ReturnsTracker(IntentLaunchChecker intentLaunchChecker, JavaContext javaContext, UElement uElement, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    bl = false;
                }
                if ((n2 & 8) != 0) {
                    n = 0;
                }
                this(intentLaunchChecker, javaContext, uElement, bl, n);
            }

            @NotNull
            public final JavaContext getContext() {
                return this.context;
            }

            public final boolean getReturned() {
                return this.returned;
            }

            public final void setReturned(boolean bl) {
                this.returned = bl;
            }

            public final int getResolveCallDepth() {
                return this.resolveCallDepth;
            }

            public final void setResolveCallDepth(int n) {
                this.resolveCallDepth = n;
            }

            @Override
            public void returns(@NotNull UReturnExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.returned = true;
            }

            @Override
            public void argument(@NotNull UCallExpression call2, @NotNull UElement reference) {
                PsiMethod psiMethod;
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                        if (this.resolveCallDepth > 3) {
                            return;
                        }
                        psiMethod = call2.resolve();
                        if (psiMethod == null) break block7;
                        PsiElement $this$toUElementOfType$iv = (PsiElement)psiMethod;
                        boolean $i$f$toUElementOfType = false;
                        psiMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                        if (psiMethod != null) break block8;
                    }
                    return;
                }
                PsiMethod containingMethod = psiMethod;
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)this.context.getEvaluator().computeArgumentMapping(call2, containingMethod.getJavaPsi()).get(reference)));
                if (uElement == null) {
                    return;
                }
                UElement tracked = uElement;
                ReturnsTracker returnsTracker = new ReturnsTracker(this.this$0, this.context, tracked, false, this.resolveCallDepth + 1, 4, null);
                PsiMethod psiMethod2 = call2.resolve();
                if (psiMethod2 != null) {
                    PsiElement $this$toUElementOfType$iv = (PsiElement)psiMethod2;
                    boolean $i$f$toUElementOfType = false;
                    psiMethod2 = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                    if (psiMethod2 != null) {
                        psiMethod2.accept((UastVisitor)returnsTracker);
                    }
                }
                this.returned = returnsTracker.returned;
            }
        }
    }
}

