/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

public class ParcelDetector
extends Detector
implements SourceCodeScanner {
    private static final String OLD_PARCELIZE = "kotlinx.android.parcel.Parcelize";
    private static final String NEW_PARCELIZE = "kotlinx.parcelize.Parcelize";
    private static final String JVM_FIELD = "kotlin.jvm.JvmField";
    public static final Issue ISSUE = Issue.create((String)"ParcelCreator", (String)"Missing Parcelable `CREATOR` field", (String)"According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.\"", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)new Implementation(ParcelDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true).addMoreInfo("https://developer.android.com/reference/android/os/Parcelable.html");

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.os.Parcelable");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        Location location;
        PsiField field;
        if (declaration instanceof UAnonymousClass) {
            return;
        }
        if (declaration.isInterface()) {
            return;
        }
        if (declaration.hasModifierProperty("abstract")) {
            return;
        }
        if (context.getEvaluator().implementsInterface(declaration.getJavaPsi(), "android.text.ParcelableSpan", false)) {
            return;
        }
        boolean isKotlin = Lint.isKotlin((Language)declaration.getLang());
        if (isKotlin) {
            PsiClass[] superClasses;
            if (ParcelDetector.hasParcelizeAnnotation((PsiModifierListOwner)declaration)) {
                return;
            }
            for (PsiClass superClass : superClasses = declaration.getJavaPsi().getSupers()) {
                KtClassOrObject ktClassOrObject;
                PsiElement parentSourcePsi;
                UClass parent = (UClass)UastContextKt.toUElement((PsiElement)superClass, UClass.class);
                if (parent == null || !ParcelDetector.hasParcelizeAnnotation((PsiModifierListOwner)parent) || !((parentSourcePsi = parent.getSourcePsi()) instanceof KtClassOrObject) || !(ktClassOrObject = (KtClassOrObject)parentSourcePsi).hasModifier(KtTokens.SEALED_KEYWORD)) continue;
                return;
            }
        }
        if ((field = declaration.getJavaPsi().findFieldByName("CREATOR", true)) == null) {
            location = context.getNameLocation(declaration);
            String message2 = "This class implements `Parcelable` but does not provide a `CREATOR` field";
            context.report(ISSUE, declaration, location, message2, null);
        } else if (Lint.isKotlin((Language)field.getLanguage()) && !ParcelDetector.hasCreatorInnerClass(declaration) && !ParcelDetector.hasJvmFieldAnnotation((PsiModifierListOwner)field)) {
            location = context.getNameLocation((PsiElement)field);
            LintFix fix2 = this.fix().name("Annotate with @JvmField", true).annotate(JVM_FIELD, (Context)context, (PsiElement)field, true).autoFix().build();
            context.report(ISSUE, (PsiElement)field, location, "Field should be annotated with `@JvmField`", fix2);
        }
    }

    private static boolean hasCreatorInnerClass(UClass declaration) {
        for (UClass inner : declaration.getInnerClasses()) {
            String name = inner.getName();
            if (!"CREATOR".equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasParcelizeAnnotation(PsiModifierListOwner owner) {
        return owner.hasAnnotation(OLD_PARCELIZE) || owner.hasAnnotation(NEW_PARCELIZE);
    }

    private static boolean hasJvmFieldAnnotation(PsiModifierListOwner owner) {
        return owner.hasAnnotation(JVM_FIELD);
    }
}

