/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.pagealign.PageAlignUtilsKt;
import com.android.tools.lint.checks.DependencyDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R<\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/PageAlignmentDetector;", "Lcom/android/tools/lint/checks/DependencyDetector;", "Lcom/android/tools/lint/checks/PageAlignmentDetector$PageAlignmentIssue;", "<init>", "()V", "isDependencyKnownSafe", "", "group", "", "artifact", "version", "dependencyIssueCache", "Ljava/util/HashMap;", "Lcom/android/tools/lint/model/LintModelMavenName;", "", "Lcom/android/tools/lint/checks/DependencyDetector$DependencyIssue;", "Lkotlin/collections/HashMap;", "getDependencyIssueCache", "()Ljava/util/HashMap;", "getIncidentsFromAndroidLibrary", "library", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "PageAlignmentIssue", "Companion", "lint-checks"})
public final class PageAlignmentDetector
extends DependencyDetector<PageAlignmentIssue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashMap<LintModelMavenName, List<DependencyDetector.DependencyIssue>> _dependencyIssueCache = new HashMap();
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isDependencyKnownSafe(@NotNull String group, @NotNull String artifact, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        var5_4 = group;
        tmp = -1;
        switch (var5_4.hashCode()) {
            case 2047842351: {
                if (var5_4.equals("com.google.mlkit")) {
                    tmp = 1;
                }
                break;
            }
            case -254881046: {
                if (var5_4.equals("com.google.mediapipe")) {
                    tmp = 2;
                }
                break;
            }
            case 1221386052: {
                if (var5_4.equals("androidx.appsearch")) {
                    tmp = 3;
                }
                break;
            }
            case -1525145678: {
                if (var5_4.equals("androidx.datastore")) {
                    tmp = 4;
                }
                break;
            }
            case 1157070781: {
                if (var5_4.equals("androidx.tracing")) {
                    tmp = 5;
                }
                break;
            }
            case 325967270: {
                if (var5_4.equals("com.google.android.gms")) {
                    tmp = 6;
                }
                break;
            }
            case 479675259: {
                if (var5_4.equals("com.google.ar.sceneform")) {
                    tmp = 7;
                }
                break;
            }
            case -775692273: {
                if (var5_4.equals("org.chromium.net")) {
                    tmp = 8;
                }
                break;
            }
            case 339729136: {
                if (var5_4.equals("androidx.graphics")) {
                    tmp = 9;
                }
                break;
            }
            case -284053597: {
                if (var5_4.equals("com.google.ai.edge.litert")) {
                    tmp = 10;
                }
                break;
            }
            case 117701712: {
                if (var5_4.equals("com.google.android.libraries.navigation")) {
                    tmp = 11;
                }
                break;
            }
            case -225004625: {
                if (var5_4.equals("com.google.firebase")) {
                    tmp = 12;
                }
                break;
            }
            case -278426150: {
                if (var5_4.equals("com.google.android.games")) {
                    tmp = 13;
                }
                break;
            }
            case 891759577: {
                if (var5_4.equals("com.google.ar")) {
                    tmp = 14;
                }
                break;
            }
            case 1067882489: {
                if (var5_4.equals("com.crashlytics.sdk.android")) {
                    tmp = 15;
                }
                break;
            }
        }
        block17 : switch (tmp) {
            case 3: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"appsearch-local-storage")) {
                    v0 = "1.1.0-alpha03";
                    break;
                }
                v0 = null;
                break;
            }
            case 4: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"datastore-core-android")) {
                    v0 = "1.1.0-beta01";
                    break;
                }
                v0 = null;
                break;
            }
            case 9: {
                var6_5 = artifact;
                if (Intrinsics.areEqual((Object)var6_5, (Object)"graphics-core")) {
                    v0 = "1.0.0-beta01";
                    break;
                }
                if (Intrinsics.areEqual((Object)var6_5, (Object)"graphics-path")) {
                    v0 = "1.0.0-beta02";
                    break;
                }
                v0 = null;
                break;
            }
            case 5: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"tracing-perfetto-binary")) {
                    v0 = "1.0.0";
                    break;
                }
                v0 = null;
                break;
            }
            case 15: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"crashlytics-ndk")) {
                    v0 = "2.1.1";
                    break;
                }
                v0 = null;
                break;
            }
            case 10: {
                var6_5 = artifact;
                if (Intrinsics.areEqual((Object)var6_5, (Object)"litert-gpu")) {
                    v0 = "1.0.1";
                    break;
                }
                if (Intrinsics.areEqual((Object)var6_5, (Object)"litert")) {
                    v0 = "1.0.1";
                    break;
                }
                v0 = null;
                break;
            }
            case 13: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"memory-advice")) {
                    v0 = "0.24";
                    break;
                }
                v0 = null;
                break;
            }
            case 6: {
                var6_5 = artifact;
                switch (var6_5.hashCode()) {
                    case 1686863899: {
                        if (!var6_5.equals("play-services-vision-image-labeling-internal")) {
                            ** break;
                        }
                        ** GOTO lbl151
                    }
                    case -1982033711: {
                        if (var6_5.equals("play-services-vision-face-contour-internal")) break;
                        ** break;
                    }
                    case 1956074425: {
                        if (!var6_5.equals("play-services-tflite-java")) ** break;
                        v0 = "16.2.0-beta02";
                        break block17;
                    }
                }
                v0 = "16.1.0";
                break;
lbl151:
                // 1 sources

                v0 = "16.1.0";
                break;
lbl153:
                // 4 sources

                v0 = null;
                break;
            }
            case 11: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"navigation")) {
                    v0 = "5.2.5";
                    break;
                }
                v0 = null;
                break;
            }
            case 14: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"core")) {
                    v0 = "1.42.0";
                    break;
                }
                v0 = null;
                break;
            }
            case 7: {
                var6_5 = artifact;
                switch (var6_5.hashCode()) {
                    case 3059615: {
                        if (!var6_5.equals("core")) {
                            ** break;
                        }
                        ** GOTO lbl187
                    }
                    case -1408207997: {
                        if (var6_5.equals("assets")) break;
                        ** break;
                    }
                    case -1627426184: {
                        if (!var6_5.equals("filament-android")) {
                            ** break;
                        }
                        ** GOTO lbl189
                    }
                    case 1118509956: {
                        if (!var6_5.equals("animation")) ** break;
                        v0 = "1.17.1";
                        break block17;
                    }
                }
                v0 = "1.17.1";
                break;
lbl187:
                // 1 sources

                v0 = "1.17.1";
                break;
lbl189:
                // 1 sources

                v0 = "1.17.1";
                break;
lbl191:
                // 5 sources

                v0 = null;
                break;
            }
            case 12: {
                var6_5 = artifact;
                tmp = -1;
                switch (var6_5.hashCode()) {
                    case 1420790011: {
                        if (var6_5.equals("firebase-crashlytics-ndk")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case -1920513181: {
                        if (var6_5.equals("firebase-ml-natural-language-language-id-model")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 886441025: {
                        if (var6_5.equals("firebase-ml-natural-language-translate-model")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -577192929: {
                        if (var6_5.equals("firebase-ml-vision-barcode-model")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -1122989799: {
                        if (var6_5.equals("firebase-ml-natural-language-smart-reply-model")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case -384492440: {
                        if (var6_5.equals("firebase-ml-vision-internal-vkp")) {
                            tmp = 6;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v0 = "19.0.1";
                        break block17;
                    }
                    case 2: {
                        v0 = "20.0.8";
                        break block17;
                    }
                    case 5: {
                        v0 = "20.0.8";
                        break block17;
                    }
                    case 3: {
                        v0 = "20.0.9";
                        break block17;
                    }
                    case 4: {
                        v0 = "16.1.2";
                        break block17;
                    }
                    case 6: {
                        v0 = "17.0.2";
                        break block17;
                    }
                }
                v0 = null;
                break;
            }
            case 2: {
                var6_5 = artifact;
                switch (var6_5.hashCode()) {
                    case 1656213255: {
                        if (!var6_5.equals("tasks-vision")) {
                            ** break;
                        }
                        ** GOTO lbl283
                    }
                    case 588564695: {
                        if (var6_5.equals("tasks-audio")) break;
                        ** break;
                    }
                    case -1991421413: {
                        if (!var6_5.equals("tasks-vision-image-generator")) {
                            ** break;
                        }
                        ** GOTO lbl281
                    }
                    case 1820652556: {
                        if (!var6_5.equals("tasks-text")) {
                            ** break;
                        }
                        ** GOTO lbl279
                    }
                    case 593638521: {
                        if (!var6_5.equals("tasks-genai")) {
                            ** break;
                        }
                        ** GOTO lbl277
                    }
                    case 1769867123: {
                        if (!var6_5.equals("solution-core")) ** break;
                        v0 = "0.10.20";
                        break block17;
                    }
                }
                v0 = "0.20230731";
                break;
lbl277:
                // 1 sources

                v0 = "0.10.20";
                break;
lbl279:
                // 1 sources

                v0 = "0.20230731";
                break;
lbl281:
                // 1 sources

                v0 = "0.10.20";
                break;
lbl283:
                // 1 sources

                v0 = "0.20230731";
                break;
lbl285:
                // 7 sources

                v0 = null;
                break;
            }
            case 1: {
                var6_5 = artifact;
                tmp = -1;
                switch (var6_5.hashCode()) {
                    case -222362786: {
                        if (var6_5.equals("barcode-scanning")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 421773072: {
                        if (var6_5.equals("vision-internal-vkp")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 48982892: {
                        if (var6_5.equals("text-recognition-bundled-common")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case -1175895120: {
                        if (var6_5.equals("language-id")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case 711666705: {
                        if (var6_5.equals("entity-extraction")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 1248022168: {
                        if (var6_5.equals("mediapipe-internal")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -1552531813: {
                        if (var6_5.equals("digital-ink-recognition")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case -1580695066: {
                        if (var6_5.equals("smart-reply")) {
                            tmp = 8;
                        }
                        break;
                    }
                    case 1052832078: {
                        if (var6_5.equals("translate")) {
                            tmp = 9;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v0 = "17.2.0";
                        break block17;
                    }
                    case 7: {
                        v0 = "18.1.0";
                        break block17;
                    }
                    case 5: {
                        v0 = "16.0.0-beta5";
                        break block17;
                    }
                    case 4: {
                        v0 = "17.0.5";
                        break block17;
                    }
                    case 6: {
                        v0 = "17.0.0-beta9";
                        break block17;
                    }
                    case 8: {
                        v0 = "17.0.3";
                        break block17;
                    }
                    case 3: {
                        v0 = "16.0.0";
                        break block17;
                    }
                    case 9: {
                        v0 = "17.0.2";
                        break block17;
                    }
                    case 2: {
                        v0 = "18.2.2";
                        break block17;
                    }
                }
                v0 = null;
                break;
            }
            case 8: {
                if (Intrinsics.areEqual((Object)artifact, (Object)"cronet-embedded")) {
                    v0 = "119.6045.31";
                    break;
                }
                v0 = null;
                break;
            }
            default: {
                v0 = lastBroken = null;
            }
        }
        if (lastBroken == null) {
            return StringsKt.startsWith$default((String)group, (String)"androidx.", (boolean)false, (int)2, null) != false || StringsKt.startsWith$default((String)group, (String)"com.google.", (boolean)false, (int)2, null) != false || StringsKt.startsWith$default((String)group, (String)"com.android.", (boolean)false, (int)2, null) != false || Intrinsics.areEqual((Object)group, (Object)"org.chromium.net") != false || StringsKt.startsWith$default((String)group, (String)"com.crashlytics.", (boolean)false, (int)2, null) != false;
        }
        parsedVersion = Version.Companion.parse(version);
        return parsedVersion.compareTo(parsedLastBrokenVersion = Version.Companion.parse(lastBroken)) > 0;
    }

    @Override
    @NotNull
    public HashMap<LintModelMavenName, List<DependencyDetector.DependencyIssue>> getDependencyIssueCache() {
        return _dependencyIssueCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DependencyDetector.DependencyIssue> getIncidentsFromAndroidLibrary(@NotNull LintModelAndroidLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        File folder = library.getFolder();
        File jniFolder = new File(folder, "jni");
        if (jniFolder.isDirectory()) {
            File[] fileArray = jniFolder.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
            for (File abiFolder : ArraysKt.sorted((Comparable[])fileArray)) {
                File[] fileArray2 = abiFolder.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray2, (String)"listFiles(...)");
                for (File sharedLibrary : ArraysKt.sorted((Comparable[])fileArray2)) {
                    if (!sharedLibrary.isFile()) continue;
                    Intrinsics.checkNotNull((Object)sharedLibrary);
                    Closeable closeable = new FileInputStream(sharedLibrary);
                    int n = 8192;
                    BufferedInputStream input = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                    closeable = input;
                    Throwable throwable = null;
                    try {
                        long minimumLoadSectionAlignment;
                        BufferedInputStream it = (BufferedInputStream)closeable;
                        boolean bl = false;
                        if (PageAlignUtilsKt.hasElfMagicNumber((InputStream)input) && (minimumLoadSectionAlignment = PageAlignUtilsKt.readElfMinimumLoadSectionAlignment((InputStream)input)) != -1L && !PageAlignUtilsKt.is16kAligned((long)minimumLoadSectionAlignment)) {
                            List list = CollectionsKt.listOf((Object)new PageAlignmentIssue(library.getResolvedCoordinates(), sharedLibrary));
                            return list;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
        }
        return CollectionsKt.emptyList();
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.TOML_SCOPE};
        Implementation implementation = new Implementation(PageAlignmentDetector.class, Scope.GRADLE_AND_TOML_SCOPE, enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"Aligned16KB", (String)"Native library dependency not 16 KB aligned", (String)"\n          Android has traditionally used 4 KB memory page sizes. However, to support \\\n          future devices that only work with 16 KB aligned libraries apps containing \\\n          native libraries need to be built with 16 KB alignment.\n\n          Apps with 4 KB aligned native libraries may not work correctly on devices \\\n          requiring 16 KB alignment. To ensure compatibility and future-proof your \\\n          app, it is strongly recommended that your native libraries are aligned to 16 \\\n          KB boundaries.\n\n          If your app uses any NDK libraries, directly or indirectly through an SDK, \\\n          you should rebuild your app to meet this recommendation. Make sure all \\\n          native libraries within your application, including those from dependencies, \\\n          are built with 16 KB page alignment.\n\n          This lint check looks at all native libraries that your app depends on. If \\\n          any are found to be aligned to 4 KB instead of 16 KB, you will need to \\\n          address this.\n\n          When a library is flagged, first try to update to a newer version that \\\n          supports 16 KB alignment. If an updated version is not available, contact \\\n          the library vendor to ask about their plans for 16 KB support and request a \\\n          compatible version. Updating your libraries proactively will help ensure \\\n          your app works properly on a wider range of devices.\n          ", (Implementation)implementation, (String)"https://developer.android.com/guide/practices/page-sizes", (Category)category, (int)2, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/PageAlignmentDetector$Companion;", "", "<init>", "()V", "_dependencyIssueCache", "Ljava/util/HashMap;", "Lcom/android/tools/lint/model/LintModelMavenName;", "", "Lcom/android/tools/lint/checks/DependencyDetector$DependencyIssue;", "Lkotlin/collections/HashMap;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/PageAlignmentDetector$PageAlignmentIssue;", "Lcom/android/tools/lint/checks/DependencyDetector$DependencyIssue;", "coordinates", "Lcom/android/tools/lint/model/LintModelMavenName;", "sharedLibrary", "Ljava/io/File;", "<init>", "(Lcom/android/tools/lint/model/LintModelMavenName;Ljava/io/File;)V", "getCoordinates", "()Lcom/android/tools/lint/model/LintModelMavenName;", "getSharedLibrary", "()Ljava/io/File;", "toLintIncident", "Lcom/android/tools/lint/detector/api/Incident;", "lint-checks"})
    public static final class PageAlignmentIssue
    extends DependencyDetector.DependencyIssue {
        @NotNull
        private final LintModelMavenName coordinates;
        @NotNull
        private final File sharedLibrary;

        public PageAlignmentIssue(@NotNull LintModelMavenName coordinates, @NotNull File sharedLibrary) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            Intrinsics.checkNotNullParameter((Object)sharedLibrary, (String)"sharedLibrary");
            this.coordinates = coordinates;
            this.sharedLibrary = sharedLibrary;
        }

        @NotNull
        public final LintModelMavenName getCoordinates() {
            return this.coordinates;
        }

        @NotNull
        public final File getSharedLibrary() {
            return this.sharedLibrary;
        }

        @Override
        @NotNull
        public Incident toLintIncident() {
            Location location = Location.Companion.create(this.sharedLibrary);
            File file = this.sharedLibrary.getParentFile();
            String libraryName = (file != null ? file.getName() : null) + "/" + this.sharedLibrary.getName();
            String message2 = "The native library `" + libraryName + "` (from `" + this.coordinates + "`) is not 16 KB aligned";
            Incident incident = new Incident(ISSUE, location, message2);
            return incident;
        }
    }
}

