/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0002*+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\rH\u0002J*\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0019H\u0002J0\u0010\"\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0007H\u0002J0\u0010'\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0007H\u0002J(\u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/NotificationTrampolineDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkNonActivityIntent", "", "pendingConstruction", "trampolineType", "Lcom/android/tools/lint/checks/NotificationTrampolineDetector$TrampolineType;", "findPendingIntentConstruction", "getTrampolineType", "pendingIntentArgument", "Lorg/jetbrains/uast/UExpression;", "Lorg/jetbrains/uast/UElement;", "seen", "", "findIntentConstruction", "findClassArgument", "constructorCall", "findClassFromLiteral", "Lcom/intellij/psi/PsiClass;", "argument", "checkReceiverOrService", "onReceiveMethod", "setPendingIntent", "broadcastClass", "description", "reportServiceOrReceiver", "startActivity", "reportNonActivityIntent", "Issues", "TrampolineType", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nNotificationTrampolineDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationTrampolineDetector.kt\ncom/android/tools/lint/checks/NotificationTrampolineDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,378:1\n1#2:379\n171#3:380\n171#3:381\n*S KotlinDebug\n*F\n+ 1 NotificationTrampolineDetector.kt\ncom/android/tools/lint/checks/NotificationTrampolineDetector\n*L\n212#1:380\n305#1:381\n*E\n"})
public final class NotificationTrampolineDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(NotificationTrampolineDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue TRAMPOLINE;
    @JvmField
    @NotNull
    public static final Issue ACTIVITY;

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setContentIntent", "setFullScreenIntent", "addAction"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, "androidx.core.app.NotificationCompat.Builder")) {
            return;
        }
        UCallExpression uCallExpression = this.findPendingIntentConstruction(node);
        if (uCallExpression == null) {
            return;
        }
        UCallExpression pendingConstruction = uCallExpression;
        TrampolineType trampolineType = this.getTrampolineType(pendingConstruction);
        if (trampolineType == null) {
            return;
        }
        TrampolineType trampolineType2 = trampolineType;
        boolean foundClass = this.checkNonActivityIntent(context, pendingConstruction, node, trampolineType2);
        if (!foundClass && !Intrinsics.areEqual((Object)Lint.getMethodName((UCallExpression)node), (Object)"addAction")) {
            this.reportNonActivityIntent(context, node, pendingConstruction, trampolineType2);
        }
    }

    private final boolean checkNonActivityIntent(JavaContext context, UCallExpression pendingConstruction, UCallExpression node, TrampolineType trampolineType) {
        boolean bl;
        Object object;
        PsiClass nonActivityClass;
        block6: {
            UCallExpression uCallExpression = this.findIntentConstruction(pendingConstruction);
            if (uCallExpression == null) {
                return false;
            }
            UCallExpression intentConstruction = uCallExpression;
            UElement uElement = this.findClassArgument(intentConstruction);
            if (uElement == null) {
                return false;
            }
            UElement classArgument = uElement;
            PsiClass psiClass = this.findClassFromLiteral(classArgument);
            if (psiClass == null) {
                return false;
            }
            nonActivityClass = psiClass;
            JavaEvaluator evaluator = context.getEvaluator();
            PsiMethod[] psiMethodArray = nonActivityClass.findMethodsByName(trampolineType.getHandlerMethodName(), false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
            for (Object object2 : (Object[])psiMethodArray) {
                PsiMethod it = (PsiMethod)object2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                String[] stringArray = trampolineType.getHandlerMethodArgTypes();
                if (!evaluator.parametersMatch(it, Arrays.copyOf(stringArray, stringArray.length))) continue;
                object = object2;
                break block6;
            }
            object = null;
        }
        PsiMethod psiMethod = (PsiMethod)object;
        if (psiMethod != null) {
            PsiMethod it = psiMethod;
            boolean bl3 = false;
            bl = this.checkReceiverOrService(context, it, node, nonActivityClass, trampolineType.getClassName());
        } else {
            bl = true;
        }
        return bl;
    }

    private final UCallExpression findPendingIntentConstruction(UCallExpression node) {
        UExpression uExpression;
        String methodName = Lint.getMethodName((UCallExpression)node);
        if (Intrinsics.areEqual((Object)methodName, (Object)"addAction") ? (uExpression = node.getArgumentForParameter(2)) == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null : (uExpression = node.getArgumentForParameter(0)) == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return null;
        }
        UExpression pendingIntentArgument = uExpression;
        return this.findPendingIntentConstruction(pendingIntentArgument, (UElement)node, new LinkedHashSet());
    }

    private final TrampolineType getTrampolineType(UCallExpression pendingConstruction) {
        String string2 = Lint.getMethodName((UCallExpression)pendingConstruction);
        return Intrinsics.areEqual((Object)string2, (Object)"getBroadcast") ? TrampolineType.BroadcastReceiver : (Intrinsics.areEqual((Object)string2, (Object)"getService") ? TrampolineType.Service : null);
    }

    private final UCallExpression findPendingIntentConstruction(UExpression pendingIntentArgument, UElement node, Set<UExpression> seen) {
        if (pendingIntentArgument == null) {
            return null;
        }
        if (!seen.add(pendingIntentArgument)) {
            return null;
        }
        PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)pendingIntentArgument));
        if (resolved instanceof PsiVariable) {
            UExpression uExpression = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, node);
            UElement uElement = uExpression != null ? UastLintUtilsKt.findSelector((UElement)((UElement)uExpression)) : null;
            return uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
        }
        if (resolved instanceof PsiMethod) {
            if (((PsiMethod)resolved).getContainingFile() instanceof PsiBinaryFile) {
                String name;
                PsiClass psiClass = ((PsiMethod)resolved).getContainingClass();
                String string2 = name = psiClass != null ? psiClass.getQualifiedName() : null;
                if (Intrinsics.areEqual((Object)name, (Object)"android.app.PendingIntent")) {
                    UExpression selector;
                    if (pendingIntentArgument instanceof UCallExpression) {
                        return (UCallExpression)pendingIntentArgument;
                    }
                    if (pendingIntentArgument instanceof UQualifiedReferenceExpression && (selector = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)pendingIntentArgument).getSelector())) instanceof UCallExpression) {
                        return (UCallExpression)selector;
                    }
                }
                return null;
            }
            PsiElement $this$toUElementOfType$iv = resolved;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod == null) {
                return null;
            }
            UMethod method = uMethod;
            Ref ref = new Ref();
            method.accept((UastVisitor)new AbstractUastVisitor(this, seen, (Ref<UCallExpression>)ref){
                final /* synthetic */ NotificationTrampolineDetector this$0;
                final /* synthetic */ Set<UExpression> $seen;
                final /* synthetic */ Ref<UCallExpression> $ref;
                {
                    this.this$0 = $receiver;
                    this.$seen = $seen;
                    this.$ref = $ref;
                }

                public boolean visitReturnExpression(UReturnExpression node) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        UExpression uExpression = node.getReturnExpression();
                        if (uExpression == null) break block1;
                        UExpression uExpression2 = uExpression;
                        NotificationTrampolineDetector notificationTrampolineDetector = this.this$0;
                        Set<UExpression> set2 = this.$seen;
                        Ref<UCallExpression> ref = this.$ref;
                        UExpression it = uExpression2;
                        boolean bl = false;
                        UCallExpression construction = NotificationTrampolineDetector.access$findPendingIntentConstruction(notificationTrampolineDetector, UastUtils.skipParenthesizedExprDown((UExpression)it), (UElement)node, set2);
                        if (construction != null && NotificationTrampolineDetector.access$getTrampolineType(notificationTrampolineDetector, construction) != null) {
                            ref.set((Object)construction);
                        }
                    }
                    return super.visitReturnExpression(node);
                }
            });
            return (UCallExpression)ref.get();
        }
        return null;
    }

    private final UCallExpression findIntentConstruction(UCallExpression pendingConstruction) {
        PsiMethod psiMethod = pendingConstruction.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod getBroadcastMethod = psiMethod;
        if (getBroadcastMethod.getParameterList().getParametersCount() != 4) {
            return null;
        }
        UExpression uExpression = pendingConstruction.getArgumentForParameter(2);
        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return null;
        }
        UExpression intentArg = uExpression;
        PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)intentArg));
        PsiVariable psiVariable = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
        if (psiVariable == null) {
            return null;
        }
        PsiVariable intentDeclaration = psiVariable;
        UExpression uExpression2 = UastLintUtils.Companion.findLastAssignment(intentDeclaration, (UElement)pendingConstruction);
        if (uExpression2 == null || (uExpression2 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2)) == null) {
            return null;
        }
        UExpression intentAssignment = uExpression2;
        psiElement = UastLintUtilsKt.findSelector((UElement)((UElement)intentAssignment));
        return psiElement instanceof UCallExpression ? (UCallExpression)psiElement : null;
    }

    private final UElement findClassArgument(UCallExpression constructorCall) {
        int n;
        PsiMethod psiMethod = constructorCall.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod intentConstructor = psiMethod;
        JvmParameter[] jvmParameterArray = intentConstructor.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
        JvmParameter[] constructorParameters = jvmParameterArray;
        switch (constructorParameters.length) {
            case 2: {
                n = 1;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            default: {
                return null;
            }
        }
        int classParameterIndex = n;
        JvmParameter classParameterType = constructorParameters[classParameterIndex];
        JvmType jvmType = classParameterType.getType();
        PsiClassType psiClassType = jvmType instanceof PsiClassType ? (PsiClassType)jvmType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType type = psiClassType;
        if (!Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)"java.lang.Class<?>")) {
            return null;
        }
        UExpression uExpression = constructorCall.getArgumentForParameter(classParameterIndex);
        return uExpression != null ? UastLintUtilsKt.findSelector((UElement)((UElement)uExpression)) : null;
    }

    private final PsiClass findClassFromLiteral(UElement argument) {
        PsiType psiType;
        if (argument instanceof UClassLiteralExpression) {
            psiType = ((UClassLiteralExpression)argument).getType();
        } else if (argument instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)argument).getResolvedName(), (Object)"getJavaClass")) {
            UExpression uExpression = ((UQualifiedReferenceExpression)argument).getReceiver();
            Intrinsics.checkNotNull((Object)uExpression, (String)"null cannot be cast to non-null type org.jetbrains.uast.UClassLiteralExpression");
            psiType = ((UClassLiteralExpression)uExpression).getType();
        } else if (argument instanceof USimpleNameReferenceExpression && argument.getUastParent() instanceof UQualifiedReferenceExpression) {
            UElement uElement = argument.getUastParent();
            Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
            UExpression receiver2 = ((UQualifiedReferenceExpression)uElement).getReceiver();
            psiType = receiver2 instanceof UClassLiteralExpression ? (UClassLiteralExpression)receiver2 : null;
            if (psiType == null || (psiType = psiType.getType()) == null) {
                return null;
            }
        } else {
            return null;
        }
        PsiType type = psiType;
        PsiClassType psiClassType = type instanceof PsiClassType ? (PsiClassType)type : null;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        PsiClassType resolved = psiClassType;
        if (resolved.getContainingFile() instanceof PsiBinaryFile) {
            return null;
        }
        return resolved;
    }

    private final boolean checkReceiverOrService(JavaContext context, PsiMethod onReceiveMethod, UCallExpression setPendingIntent, PsiClass broadcastClass, String description) {
        PsiElement $this$toUElementOfType$iv = (PsiElement)onReceiveMethod;
        boolean $i$f$toUElementOfType = false;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
        if (uMethod == null) {
            return false;
        }
        UMethod method = uMethod;
        method.accept((UastVisitor)new AbstractUastVisitor(this, context, setPendingIntent, broadcastClass, description){
            final /* synthetic */ NotificationTrampolineDetector this$0;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ UCallExpression $setPendingIntent;
            final /* synthetic */ PsiClass $broadcastClass;
            final /* synthetic */ String $description;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$setPendingIntent = $setPendingIntent;
                this.$broadcastClass = $broadcastClass;
                this.$description = $description;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String methodName = Lint.getMethodName((UCallExpression)node);
                if (Intrinsics.areEqual((Object)methodName, (Object)"startActivity") || Intrinsics.areEqual((Object)methodName, (Object)"startActivities")) {
                    NotificationTrampolineDetector.access$reportServiceOrReceiver(this.this$0, this.$context, node, this.$setPendingIntent, this.$broadcastClass, this.$description);
                }
                return super.visitCallExpression(node);
            }
        });
        return true;
    }

    private final void reportServiceOrReceiver(JavaContext context, UCallExpression startActivity, UCallExpression setPendingIntent, PsiClass broadcastClass, String description) {
        Location primaryLocation = context.getCallLocation(setPendingIntent, false, true);
        Location secondaryLocation = context.getCallLocation(startActivity, true, true);
        primaryLocation.setSecondary(secondaryLocation);
        String message2 = "This intent launches a `" + description + "` (`" + broadcastClass.getName() + "`) which launches activities; this indirection is bad for performance, and activities should be launched directly from the notification";
        JavaContext.report$default((JavaContext)context, (Issue)TRAMPOLINE, (UElement)((UElement)setPendingIntent), (Location)primaryLocation, (String)message2, null, (int)16, null);
    }

    private final void reportNonActivityIntent(JavaContext context, UCallExpression setPendingIntent, UCallExpression pendingConstruction, TrampolineType trampolineType) {
        String className = trampolineType.getClassName();
        String message2 = "Notifications should only launch a `" + className + "` from notification actions (`addAction`)";
        Location location = context.getCallLocation(setPendingIntent, false, true);
        Location secondary = context.getCallLocation(pendingConstruction, true, true);
        secondary.setMessage("This `" + className + "` intent is launched from a notification; this is discouraged except as notification actions");
        location.setSecondary(secondary);
        JavaContext.report$default((JavaContext)context, (Issue)ACTIVITY, (UElement)((UElement)setPendingIntent), (Location)location, (String)message2, null, (int)16, null);
    }

    public static final /* synthetic */ UCallExpression access$findPendingIntentConstruction(NotificationTrampolineDetector $this, UExpression pendingIntentArgument, UElement node, Set seen) {
        return $this.findPendingIntentConstruction(pendingIntentArgument, node, seen);
    }

    public static final /* synthetic */ TrampolineType access$getTrampolineType(NotificationTrampolineDetector $this, UCallExpression pendingConstruction) {
        return $this.getTrampolineType(pendingConstruction);
    }

    public static final /* synthetic */ void access$reportServiceOrReceiver(NotificationTrampolineDetector $this, JavaContext context, UCallExpression startActivity, UCallExpression setPendingIntent, PsiClass broadcastClass, String description) {
        $this.reportServiceOrReceiver(context, startActivity, setPendingIntent, broadcastClass, description);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        TRAMPOLINE = Issue.Companion.create$default((Issue.Companion)companion, (String)"NotificationTrampoline", (String)"Notification Trampolines", (String)"\n                Activities should not be launched indirectly from a notification via an \\\n                intermediate `BroadcastReceiver` or `Service`. This can lead to significant lags \\\n                in some scenarios, and is forbidden if `targetSdkVersion` is set to the API level \\\n                for Android 12 or higher.\n\n                To fix this, launch the `Activity` directly from the notification.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ACTIVITY = Issue.Companion.create$default((Issue.Companion)companion, (String)"LaunchActivityFromNotification", (String)"Notification Launches Services or BroadcastReceivers", (String)"\n                Notifications should only launch activities -- that's what users expect (and \\\n                has been the guidance in both the Android SDK and Material Design documentation \\\n                for a while).\n\n                A `Service` or a `BroadcastReceiver` should not be used as an intermediate, \\\n                because this can lead to significant performance problems, and as a \\\n                result, this will not be allowed in Android 12.\n                ", (Implementation)implementation, null, (Category)category, (int)3, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null).addMoreInfo("https://developer.android.com/guide/topics/ui/notifiers/notifications?hl=en#Actions").addMoreInfo("https://d.android.com/r/studio-ui/designer/material/notifications-behavior").addMoreInfo("https://developer.android.com/guide/topics/ui/notifiers/notifications?hl=en");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/NotificationTrampolineDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TRAMPOLINE", "Lcom/android/tools/lint/detector/api/Issue;", "ACTIVITY", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/NotificationTrampolineDetector$TrampolineType;", "", "handlerMethodName", "", "handlerMethodArgTypes", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;[Ljava/lang/String;)V", "getHandlerMethodName", "()Ljava/lang/String;", "getHandlerMethodArgTypes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "BroadcastReceiver", "Service", "className", "getClassName", "lint-checks"})
    private static final class TrampolineType
    extends Enum<TrampolineType> {
        @NotNull
        private final String handlerMethodName;
        @NotNull
        private final String[] handlerMethodArgTypes;
        public static final /* enum */ TrampolineType BroadcastReceiver;
        public static final /* enum */ TrampolineType Service;
        private static final /* synthetic */ TrampolineType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TrampolineType(String handlerMethodName, String ... handlerMethodArgTypes) {
            this.handlerMethodName = handlerMethodName;
            this.handlerMethodArgTypes = handlerMethodArgTypes;
        }

        @NotNull
        public final String getHandlerMethodName() {
            return this.handlerMethodName;
        }

        @NotNull
        public final String[] getHandlerMethodArgTypes() {
            return this.handlerMethodArgTypes;
        }

        @NotNull
        public final String getClassName() {
            return this.name();
        }

        public static TrampolineType[] values() {
            return (TrampolineType[])$VALUES.clone();
        }

        public static TrampolineType valueOf(String value) {
            return Enum.valueOf(TrampolineType.class, value);
        }

        @NotNull
        public static EnumEntries<TrampolineType> getEntries() {
            return $ENTRIES;
        }

        static {
            String[] stringArray = new String[]{"android.content.Context", "android.content.Intent"};
            BroadcastReceiver = new TrampolineType("onReceive", stringArray);
            stringArray = new String[]{"android.content.Intent", "int", "int"};
            Service = new TrampolineType("onStartCommand", stringArray);
            $VALUES = trampolineTypeArray = new TrampolineType[]{TrampolineType.BroadcastReceiver, TrampolineType.Service};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

