/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/AllCapsDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "<init>", "()V", "getApplicableAttributes", "", "", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "Issues", "lint-checks"})
public final class AllCapsDetector
extends LayoutDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"textAllCaps");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        boolean full;
        Project project;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)"true", (Object)attribute.getValue())) {
            return;
        }
        String text = attribute.getOwnerElement().getAttributeNS("http://schemas.android.com/apk/res/android", "text");
        Intrinsics.checkNotNull((Object)text);
        if (((CharSequence)text).length() == 0) {
            return;
        }
        ResourceUrl url = ResourceUrl.parse((String)text);
        if (url == null || url.isFramework()) {
            return;
        }
        LintClient client = context.getClient();
        ResourceRepository repository2 = client.getResources(project = (full = context.isGlobalAnalysis()) ? context.getMainProject() : context.getProject(), ResourceRepositoryScope.ALL_DEPENDENCIES);
        List items = repository2.getResources(ResourceNamespace.TODO(), url.type, url.name);
        if (items.isEmpty()) {
            return;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue();
        if (resourceValue == null) {
            return;
        }
        ResourceValue resourceValue2 = resourceValue;
        String string2 = resourceValue2.getRawXmlValue();
        if (string2 == null) {
            return;
        }
        String rawXmlValue = string2;
        if (StringsKt.contains$default((CharSequence)rawXmlValue, (CharSequence)"<", (boolean)false, (int)2, null)) {
            String message2 = "Using `textAllCaps` with a string (`" + url.name + "`) that contains markup; the markup will be dropped by the caps conversion";
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)message2, null, (int)16, null);
        }
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE};
        ISSUE = Issue.Companion.create("AllCaps", "Combining textAllCaps and markup", "\n            The textAllCaps text transform will end up calling `toString` on the `CharSequence`, which has \\\n            the net effect of removing any markup such as `<b>`. This check looks for usages of strings \\\n            containing markup that also specify `textAllCaps=true`.", Category.TYPOGRAPHY, 8, Severity.WARNING, new Implementation(AllCapsDetector.class, Scope.ALL_RESOURCES_SCOPE, enumSetArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/AllCapsDetector$Issues;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

