/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AccessibilityViewScrollActionsDetectorKt;
import com.android.tools.lint.checks.EscapeCheckingDataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/AccessibilityViewScrollActionsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "checkInitializeMethod", "psiClass", "Lcom/intellij/psi/PsiClass;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nAccessibilityViewScrollActionsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityViewScrollActionsDetector.kt\ncom/android/tools/lint/checks/AccessibilityViewScrollActionsDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,293:1\n385#2,11:294\n385#2,11:306\n171#3:305\n171#3:317\n*S KotlinDebug\n*F\n+ 1 AccessibilityViewScrollActionsDetector.kt\ncom/android/tools/lint/checks/AccessibilityViewScrollActionsDetector\n*L\n115#1:294,11\n125#1:306,11\n116#1:305\n126#1:317\n*E\n"})
public final class AccessibilityViewScrollActionsDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ACTION_SCROLL_FORWARD = 4096;
    private static final int ACTION_SCROLL_BACKWARD = 8192;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"android.view.View");
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PsiClass psiClass = declaration.getJavaPsi();
        Object object = psiClass instanceof PsiClass ? psiClass : null;
        if (object == null) {
            return;
        }
        PsiClass psiClass2 = object;
        this.checkInitializeMethod(context, psiClass2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkInitializeMethod(JavaContext context, PsiClass psiClass) {
        UMethod $this$singleOrNull$iv;
        block12: {
            block11: {
                void $this$toUElementOfType$iv;
                Object v1;
                block10: {
                    if (!context.getEvaluator().inheritsFrom(psiClass, "android.view.View", true)) {
                        return;
                    }
                    if (context.getEvaluator().inheritsFrom(psiClass, "android.widget.ScrollView", false)) {
                        return;
                    }
                    PsiMethod[] psiMethodArray = psiClass.findMethodsByName("onInitializeAccessibilityNodeInfo", false);
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
                    Sequence sequence2 = ArraysKt.asSequence((Object[])psiMethodArray);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!AccessibilityViewScrollActionsDetector.checkInitializeMethod$isInitializeMethod(context, it)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block10;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                PsiMethod psiMethod = v1;
                if (psiMethod == null) break block11;
                PsiElement $i$f$singleOrNull = (PsiElement)psiMethod;
                boolean $i$f$toUElementOfType = false;
                $this$singleOrNull$iv = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                if ($this$singleOrNull$iv != null) break block12;
            }
            return;
        }
        UMethod initializeMethod = $this$singleOrNull$iv;
        UParameter uParameter = (UParameter)CollectionsKt.getOrNull((List)initializeMethod.getUastParameters(), (int)0);
        if (uParameter == null) {
            return;
        }
        UParameter accessibilityNodeInfoParam = uParameter;
        Ref.BooleanRef addsForwardBackward = new Ref.BooleanRef();
        Ref.BooleanRef addsUpDownLeftRight = new Ref.BooleanRef();
        Ref.BooleanRef setsCollectionInfo = new Ref.BooleanRef();
        Ref.BooleanRef setsClassNameToScrollView = new Ref.BooleanRef();
        Lazy superMethods2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<PsiMethod[]>(initializeMethod){
            final /* synthetic */ UMethod $initializeMethod;
            {
                this.$initializeMethod = $initializeMethod;
                super(0);
            }

            public final PsiMethod[] invoke() {
                PsiMethod[] psiMethodArray = this.$initializeMethod.getJavaPsi();
                Object object = psiMethodArray instanceof PsiMethod ? psiMethodArray : null;
                if (object == null || (object = object.findSuperMethods()) == null) {
                    object = new PsiMethod[]{};
                }
                return object;
            }
        }));
        List list = CollectionsKt.listOf((Object)accessibilityNodeInfoParam);
        EscapeCheckingDataFlowAnalyzer dfa2 = new EscapeCheckingDataFlowAnalyzer((Lazy<? extends PsiMethod[]>)superMethods2, addsForwardBackward, addsUpDownLeftRight, setsCollectionInfo, setsClassNameToScrollView, list){
            final /* synthetic */ Lazy<PsiMethod[]> $superMethods;
            final /* synthetic */ Ref.BooleanRef $addsForwardBackward;
            final /* synthetic */ Ref.BooleanRef $addsUpDownLeftRight;
            final /* synthetic */ Ref.BooleanRef $setsCollectionInfo;
            final /* synthetic */ Ref.BooleanRef $setsClassNameToScrollView;
            {
                this.$superMethods = $superMethods;
                this.$addsForwardBackward = $addsForwardBackward;
                this.$addsUpDownLeftRight = $addsUpDownLeftRight;
                this.$setsCollectionInfo = $setsCollectionInfo;
                this.$setsClassNameToScrollView = $setsClassNameToScrollView;
                super($super_call_param$1, null, 2, null);
            }

            public void argument(UCallExpression call2, UElement reference) {
                boolean isSuperCall;
                block4: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                    PsiMethod psiMethod = call2.resolve();
                    if (psiMethod != null) {
                        PsiMethod psiMethod2 = psiMethod;
                        Lazy<PsiMethod[]> lazy = this.$superMethods;
                        PsiMethod resolved = psiMethod2;
                        boolean bl2 = false;
                        Object[] $this$any$iv = (Object[])lazy.getValue();
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiMethod sup = (PsiMethod)element$iv;
                            boolean bl3 = false;
                            if (!resolved.isEquivalentTo((PsiElement)sup)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    } else {
                        bl = isSuperCall = false;
                    }
                }
                if (!isSuperCall) {
                    super.argument(call2, reference);
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void receiver(UCallExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                super.receiver(call2);
                String string2 = call2.getMethodName();
                if (string2 == null) return;
                int n = -1;
                switch (string2.hashCode()) {
                    case -530110921: {
                        if (!string2.equals("addAction")) break;
                        n = 1;
                        break;
                    }
                    case 1529499105: {
                        if (!string2.equals("setClassName")) break;
                        n = 2;
                        break;
                    }
                    case -921551506: {
                        if (!string2.equals("setCollectionInfo")) break;
                        n = 3;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        PsiField paramField;
                        UExpression uExpression = call2.getArgumentForParameter(0);
                        if (uExpression == null) {
                            return;
                        }
                        UExpression param = uExpression;
                        UReferenceExpression uReferenceExpression = param instanceof UReferenceExpression ? (UReferenceExpression)param : null;
                        Object object = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
                        PsiField psiField = paramField = object instanceof PsiField ? (PsiField)object : null;
                        if (paramField != null) {
                            switch (paramField.getName()) {
                                case "ACTION_SCROLL_BACKWARD": 
                                case "ACTION_SCROLL_FORWARD": {
                                    this.$addsForwardBackward.element = true;
                                    return;
                                }
                                case "ACTION_SCROLL_LEFT": 
                                case "ACTION_SCROLL_RIGHT": 
                                case "ACTION_SCROLL_DOWN": 
                                case "ACTION_SCROLL_UP": {
                                    this.$addsUpDownLeftRight.element = true;
                                    return;
                                }
                            }
                            return;
                        }
                        Object paramValue = param.evaluate();
                        if (!(paramValue instanceof Integer)) return;
                        switch (((Number)paramValue).intValue()) {
                            case 4096: 
                            case 8192: {
                                this.$addsForwardBackward.element = true;
                                return;
                            }
                        }
                        return;
                    }
                    case 3: {
                        UExpression uExpression = call2.getArgumentForParameter(0);
                        UExpression uExpression2 = uExpression;
                        if (uExpression == null) return;
                        if ((uExpression2 = uExpression2.getSourcePsi()) == null) {
                            return;
                        }
                        UExpression paramPsi = uExpression2;
                        if (paramPsi instanceof PsiLiteralExpression) return;
                        if (paramPsi instanceof KtConstantExpression) {
                            return;
                        }
                        this.$setsCollectionInfo.element = true;
                        return;
                    }
                    case 2: {
                        UExpression uExpression = call2.getArgumentForParameter(0);
                        if (uExpression == null) {
                            return;
                        }
                        UExpression param = uExpression;
                        PsiElement paramPsi = param.getSourcePsi();
                        if (paramPsi instanceof PsiLiteralExpression) return;
                        if (paramPsi instanceof KtConstantExpression) {
                            return;
                        }
                        if (!AccessibilityViewScrollActionsDetectorKt.access$isScrollViewClassNameString(param)) return;
                        this.$setsClassNameToScrollView.element = true;
                        return;
                    }
                }
            }
        };
        initializeMethod.accept((UastVisitor)dfa2);
        if (!dfa2.getEscaped() && addsForwardBackward.element && !addsUpDownLeftRight.element && (setsCollectionInfo.element || setsClassNameToScrollView.element || AccessibilityViewScrollActionsDetector.checkInitializeMethod$overridesAccessibilityClassNameAsScrollView(psiClass, context))) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)initializeMethod), (Location)context.getLocation(initializeMethod), (String)"Views that behave like `ScrollView` and support `ACTION_SCROLL_{FORWARD,BACKWARD}` should also support `ACTION_SCROLL_{LEFT,RIGHT}` and/or `ACTION_SCROLL_{UP,DOWN}`", null, (int)16, null);
        }
    }

    private static final boolean checkInitializeMethod$isInitializeMethod(JavaContext $context, PsiMethod method) {
        if (!Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)method.getReturnType())) {
            return false;
        }
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] parameters = psiParameterArray;
        if (parameters.length != 1) {
            return false;
        }
        PsiParameter parameter = parameters[0];
        if (parameter.isVarArgs()) {
            return false;
        }
        PsiType psiType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType type = psiType;
        if (!(type instanceof PsiClassReferenceType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((PsiClassReferenceType)type).getReference().getQualifiedName(), (Object)"android.view.accessibility.AccessibilityNodeInfo")) {
            return false;
        }
        return $context.getEvaluator().isOverride(method, false);
    }

    private static final boolean checkInitializeMethod$isGetAccessibilityClassNameMethod(JavaContext $context, PsiMethod method) {
        PsiType psiType = method.getReturnType();
        PsiClassReferenceType psiClassReferenceType = psiType instanceof PsiClassReferenceType ? (PsiClassReferenceType)psiType : null;
        if (psiClassReferenceType == null) {
            return false;
        }
        PsiClassReferenceType returnType = psiClassReferenceType;
        if (!Intrinsics.areEqual((Object)returnType.getReference().getQualifiedName(), (Object)"java.lang.CharSequence")) {
            return false;
        }
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] parameters = psiParameterArray;
        if (!(parameters.length == 0)) {
            return false;
        }
        return $context.getEvaluator().isOverride(method, false);
    }

    private static final boolean checkInitializeMethod$overridesAccessibilityClassNameAsScrollView(PsiClass $psiClass, JavaContext $context) {
        UExpression $this$toUElementOfType$iv;
        UMethod $this$singleOrNull$iv;
        block11: {
            block10: {
                Object v1;
                block9: {
                    PsiMethod[] psiMethodArray = $psiClass.findMethodsByName("getAccessibilityClassName", false);
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
                    Sequence sequence2 = ArraysKt.asSequence((Object[])psiMethodArray);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!AccessibilityViewScrollActionsDetector.checkInitializeMethod$isGetAccessibilityClassNameMethod($context, it)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block9;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                PsiMethod psiMethod = v1;
                if (psiMethod == null) break block10;
                PsiElement $i$f$singleOrNull = (PsiElement)psiMethod;
                boolean $i$f$toUElementOfType = false;
                $this$singleOrNull$iv = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                if ($this$singleOrNull$iv != null) break block11;
            }
            return false;
        }
        UMethod classNameMethod = $this$singleOrNull$iv;
        $this$toUElementOfType$iv = classNameMethod.getUastBody();
        UBlockExpression uBlockExpression = $this$toUElementOfType$iv instanceof UBlockExpression ? (UBlockExpression)$this$toUElementOfType$iv : null;
        if (uBlockExpression == null) {
            return false;
        }
        UBlockExpression block = uBlockExpression;
        List expressions = block.getExpressions();
        if (expressions.size() != 1) {
            return false;
        }
        Object e = expressions.get(0);
        UReturnExpression uReturnExpression = e instanceof UReturnExpression ? (UReturnExpression)e : null;
        if (uReturnExpression == null) {
            return false;
        }
        UReturnExpression returnExpression = uReturnExpression;
        UExpression uExpression = returnExpression.getReturnExpression();
        return uExpression != null ? AccessibilityViewScrollActionsDetectorKt.access$isScrollViewClassNameString(uExpression) : false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.A11Y;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(AccessibilityViewScrollActionsDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"AccessibilityScrollActions", (String)"Incomplete Scroll Action support", (String)"\n          Views that behave like `ScrollView` and support `ACTION_SCROLL_{FORWARD,BACKWARD}` should also support \\\n          `ACTION_SCROLL_{LEFT,RIGHT}` and/or `ACTION_SCROLL_{UP,DOWN}`.\n          ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/AccessibilityViewScrollActionsDetector$Companion;", "", "<init>", "()V", "ACTION_SCROLL_FORWARD", "", "ACTION_SCROLL_BACKWARD", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

