/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.WasmJsInteropTypesCheckerKt;
import org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmJsInteropTypesChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public final class WasmJsInteropTypesChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmJsInteropTypesChecker INSTANCE = new WasmJsInteropTypesChecker();

    private WasmJsInteropTypesChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        block10: {
            MemberDescriptor memberDescriptor;
            BindingTrace trace;
            block11: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    if (!(descriptor instanceof MemberDescriptor)) {
                        return;
                    }
                    trace = context2.getTrace();
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    BindingContext bindingContext2 = bindingContext;
                    if (!(WasmJsInteropTypesChecker.check$isExternalJsInteropDeclaration(descriptor) || WasmJsInteropTypesChecker.check$isJsCodeDeclaration(descriptor, bindingContext2) || WasmJsInteropTypesChecker.check$isJsExportDeclaration(descriptor, bindingContext2))) {
                        return;
                    }
                    memberDescriptor = (MemberDescriptor)descriptor;
                    if (!(memberDescriptor instanceof ClassDescriptor)) break block9;
                    for (TypeParameterDescriptor typeParameter : ((ClassDescriptor)descriptor).getDeclaredTypeParameters()) {
                        Intrinsics.checkNotNull((Object)typeParameter);
                        WasmJsInteropTypesChecker.check$checkJsInteropTypeParameter(typeParameter, declaration, trace);
                    }
                    break block10;
                }
                if (!(memberDescriptor instanceof PropertyDescriptor)) break block11;
                for (TypeParameterDescriptor typeParameter : ((PropertyDescriptor)descriptor).getTypeParameters()) {
                    Intrinsics.checkNotNull((Object)typeParameter);
                    WasmJsInteropTypesChecker.check$checkJsInteropTypeParameter(typeParameter, declaration, trace);
                }
                KotlinType kotlinType = ((PropertyDescriptor)descriptor).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                WasmJsInteropTypesChecker.check$checkJsInteropType$default(kotlinType, trace, "external property", declaration, false, 8, null);
                break block10;
            }
            if (!(memberDescriptor instanceof FunctionDescriptor)) break block10;
            for (TypeParameterDescriptor typeParameter : ((FunctionDescriptor)descriptor).getTypeParameters()) {
                Intrinsics.checkNotNull((Object)typeParameter);
                WasmJsInteropTypesChecker.check$checkJsInteropTypeParameter(typeParameter, declaration, trace);
            }
            for (ValueParameterDescriptor parameter : ((FunctionDescriptor)descriptor).getValueParameters()) {
                KotlinType kotlinType = parameter.getVarargElementType();
                if (kotlinType == null) {
                    KotlinType kotlinType2 = parameter.getType();
                    kotlinType = kotlinType2;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                }
                KotlinType typeToCheck = kotlinType;
                Intrinsics.checkNotNull((Object)parameter);
                PsiElement psiElement = SourceLocationUtilsKt.findPsi(parameter);
                if (psiElement == null) {
                    psiElement = declaration;
                }
                WasmJsInteropTypesChecker.check$checkJsInteropType$default(typeToCheck, trace, "external function parameter", psiElement, false, 8, null);
            }
            KotlinType kotlinType = ((FunctionDescriptor)descriptor).getReturnType();
            if (kotlinType != null) {
                WasmJsInteropTypesChecker.check$checkJsInteropType(kotlinType, trace, "external function return", declaration, true);
            }
        }
    }

    private static final boolean check$isExternalJsInteropDeclaration(DeclarationDescriptor $descriptor) {
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)$descriptor) && !$descriptor.getAnnotations().hasAnnotation(new FqName("kotlin.wasm.WasmImport"));
    }

    private static final boolean check$isJsCodeDeclaration(DeclarationDescriptor $descriptor, BindingContext bindingContext) {
        return $descriptor instanceof FunctionDescriptor && JsCodeUtilsKt.hasValidJsCodeBody((FunctionDescriptor)$descriptor, bindingContext) || $descriptor instanceof PropertyDescriptor && JsCodeUtilsKt.hasValidJsCodeBody((PropertyDescriptor)$descriptor, bindingContext);
    }

    private static final boolean check$isJsExportDeclaration(DeclarationDescriptor $descriptor, BindingContext bindingContext) {
        return AnnotationsUtils.isExportedObject($descriptor, bindingContext);
    }

    private static final void check$checkJsInteropType(KotlinType $this$check_u24checkJsInteropType, BindingTrace trace, String typePositionDescription, PsiElement reportOn, boolean isInFunctionReturnPosition) {
        if (!WasmJsInteropTypesCheckerKt.access$isTypeSupportedInJsInterop($this$check_u24checkJsInteropType, isInFunctionReturnPosition)) {
            trace.report(ErrorsWasm.WRONG_JS_INTEROP_TYPE.on(reportOn, typePositionDescription, $this$check_u24checkJsInteropType));
        }
    }

    static /* synthetic */ void check$checkJsInteropType$default(KotlinType kotlinType, BindingTrace bindingTrace, String string, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        WasmJsInteropTypesChecker.check$checkJsInteropType(kotlinType, bindingTrace, string, psiElement, bl);
    }

    private static final void check$checkJsInteropTypeParameter(TypeParameterDescriptor $this$check_u24checkJsInteropTypeParameter, KtDeclaration $declaration, BindingTrace trace) {
        for (KotlinType upperBound : $this$check_u24checkJsInteropTypeParameter.getUpperBounds()) {
            Intrinsics.checkNotNull((Object)upperBound);
            if (WasmJsInteropTypesCheckerKt.access$isTypeSupportedInJsInterop(upperBound, false)) continue;
            PsiElement psiElement = SourceLocationUtilsKt.findPsi($this$check_u24checkJsInteropTypeParameter);
            if (psiElement == null) {
                psiElement = $declaration;
            }
            PsiElement reportOn = psiElement;
            trace.report(ErrorsWasm.WRONG_JS_INTEROP_TYPE.on(reportOn, "type parameter upper bound", upperBound));
        }
    }
}

