/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PackageFragmentDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorUtils;

public class DescriptorUtils {
    public static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");

    private DescriptorUtils() {
    }

    @Nullable
    public static ReceiverParameterDescriptor getDispatchReceiverParameterIfNeeded(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            DescriptorUtils.$$$reportNull$$$0(0);
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            return classDescriptor.getThisAsReceiverParameter();
        }
        return null;
    }

    public static boolean isLocal(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(1);
        }
        for (DeclarationDescriptor current = descriptor; current != null; current = current.getContainingDeclaration()) {
            if (!DescriptorUtils.isAnonymousObject(current) && !DescriptorUtils.isDescriptorWithLocalVisibility(current)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescriptorWithLocalVisibility(DeclarationDescriptor current) {
        return current instanceof DeclarationDescriptorWithVisibility && ((DeclarationDescriptorWithVisibility)current).getVisibility() == DescriptorVisibilities.LOCAL;
    }

    @NotNull
    public static FqNameUnsafe getFqName(@NotNull DeclarationDescriptor descriptor) {
        FqName safe;
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(2);
        }
        return (safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor)) != null ? safe.toUnsafe() : DescriptorUtils.getFqNameUnsafe(descriptor);
    }

    @NotNull
    public static FqName getFqNameSafe(@NotNull DeclarationDescriptor descriptor) {
        FqName safe;
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(3);
        }
        FqName fqName = (safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor)) != null ? safe : DescriptorUtils.getFqNameUnsafe(descriptor).toSafe();
        if (fqName == null) {
            DescriptorUtils.$$$reportNull$$$0(4);
        }
        return fqName;
    }

    @Nullable
    private static FqName getFqNameSafeIfPossible(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(5);
        }
        if (descriptor instanceof ModuleDescriptor || ErrorUtils.isError(descriptor)) {
            return FqName.ROOT;
        }
        if (descriptor instanceof PackageViewDescriptor) {
            return ((PackageViewDescriptor)descriptor).getFqName();
        }
        if (descriptor instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)descriptor).getFqName();
        }
        return null;
    }

    @NotNull
    private static FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(6);
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        assert (containingDeclaration != null) : "Not package/module descriptor doesn't have containing declaration: " + descriptor;
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(containingDeclaration).child(descriptor.getName());
        if (fqNameUnsafe == null) {
            DescriptorUtils.$$$reportNull$$$0(7);
        }
        return fqNameUnsafe;
    }

    @NotNull
    public static FqName getFqNameFromTopLevelClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(8);
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        Name name2 = descriptor.getName();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            FqName fqName = FqName.topLevel(name2);
            if (fqName == null) {
                DescriptorUtils.$$$reportNull$$$0(9);
            }
            return fqName;
        }
        FqName fqName = DescriptorUtils.getFqNameFromTopLevelClass(containingDeclaration).child(name2);
        if (fqName == null) {
            DescriptorUtils.$$$reportNull$$$0(10);
        }
        return fqName;
    }

    @NotNull
    public static ClassId getClassIdForNonLocalClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(11);
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        Name name2 = descriptor.getName();
        if (containingDeclaration instanceof PackageFragmentDescriptorImpl) {
            FqName packageFqName = ((PackageFragmentDescriptorImpl)containingDeclaration).getFqName();
            return new ClassId(packageFqName, name2);
        }
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return new ClassId(FqName.ROOT, name2);
        }
        ClassId classId = DescriptorUtils.getClassIdForNonLocalClass(containingDeclaration).createNestedClassId(name2);
        if (classId == null) {
            DescriptorUtils.$$$reportNull$$$0(12);
        }
        return classId;
    }

    public static boolean isTopLevelDeclaration(@Nullable DeclarationDescriptor descriptor) {
        return descriptor != null && descriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static boolean isExtension(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(13);
        }
        return descriptor.getExtensionReceiverParameter() != null;
    }

    public static boolean isOverride(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(14);
        }
        return !descriptor.getOverriddenDescriptors().isEmpty();
    }

    public static boolean isStaticDeclaration(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(15);
        }
        if (descriptor instanceof ConstructorDescriptor) {
            return false;
        }
        DeclarationDescriptor container = descriptor.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor || container instanceof ClassDescriptor && descriptor.getDispatchReceiverParameter() == null;
    }

    public static boolean areInSameModule(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        if (first == null) {
            DescriptorUtils.$$$reportNull$$$0(16);
        }
        if (second == null) {
            DescriptorUtils.$$$reportNull$$$0(17);
        }
        return DescriptorUtils.getContainingModule(first).equals(DescriptorUtils.getContainingModule(second));
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass) {
        if (aClass == null) {
            DescriptorUtils.$$$reportNull$$$0(18);
        }
        return DescriptorUtils.getParentOfType(descriptor, aClass, true);
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass, boolean strict) {
        if (aClass == null) {
            DescriptorUtils.$$$reportNull$$$0(19);
        }
        if (descriptor == null) {
            return null;
        }
        if (strict) {
            descriptor = descriptor.getContainingDeclaration();
        }
        while (descriptor != null) {
            if (aClass.isInstance(descriptor)) {
                return (D)descriptor;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return null;
    }

    @Nullable
    public static ModuleDescriptor getContainingModuleOrNull(@NotNull KotlinType kotlinType) {
        ClassifierDescriptor descriptor;
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(20);
        }
        if ((descriptor = kotlinType.getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        return DescriptorUtils.getContainingModuleOrNull(descriptor);
    }

    @NotNull
    public static ModuleDescriptor getContainingModule(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(21);
        }
        ModuleDescriptor module2 = DescriptorUtils.getContainingModuleOrNull(descriptor);
        assert (module2 != null) : "Descriptor without a containing module: " + descriptor;
        ModuleDescriptor moduleDescriptor = module2;
        if (moduleDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(22);
        }
        return moduleDescriptor;
    }

    @Nullable
    public static ModuleDescriptor getContainingModuleOrNull(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(23);
        }
        while (descriptor != null) {
            if (descriptor instanceof ModuleDescriptor) {
                return (ModuleDescriptor)descriptor;
            }
            if (descriptor instanceof PackageViewDescriptor) {
                return ((PackageViewDescriptor)descriptor).getModule();
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(24);
        }
        for (DeclarationDescriptor containing = descriptor.getContainingDeclaration(); containing != null; containing = containing.getContainingDeclaration()) {
            if (!(containing instanceof ClassDescriptor) || DescriptorUtils.isCompanionObject(containing)) continue;
            return (ClassDescriptor)containing;
        }
        return null;
    }

    public static boolean isAncestor(@Nullable DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor, boolean strict) {
        DeclarationDescriptor descriptor;
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(25);
        }
        if (ancestor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor = strict ? declarationDescriptor.getContainingDeclaration() : declarationDescriptor;
        while (descriptor != null) {
            if (ancestor == descriptor) {
                return true;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return false;
    }

    public static boolean isDirectSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        if (subClass == null) {
            DescriptorUtils.$$$reportNull$$$0(26);
        }
        if (superClass == null) {
            DescriptorUtils.$$$reportNull$$$0(27);
        }
        for (KotlinType superType : subClass.getTypeConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSameClass(superType, superClass.getOriginal())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        if (subClass == null) {
            DescriptorUtils.$$$reportNull$$$0(28);
        }
        if (superClass == null) {
            DescriptorUtils.$$$reportNull$$$0(29);
        }
        return DescriptorUtils.isSubtypeOfClass(subClass.getDefaultType(), superClass.getOriginal());
    }

    private static boolean isSameClass(@NotNull KotlinType type, @NotNull DeclarationDescriptor other) {
        DeclarationDescriptor originalDescriptor;
        ClassifierDescriptor descriptor;
        if (type == null) {
            DescriptorUtils.$$$reportNull$$$0(30);
        }
        if (other == null) {
            DescriptorUtils.$$$reportNull$$$0(31);
        }
        return (descriptor = type.getConstructor().getDeclarationDescriptor()) != null && (originalDescriptor = descriptor.getOriginal()) instanceof ClassifierDescriptor && other instanceof ClassifierDescriptor && ((ClassifierDescriptor)other).getTypeConstructor().equals(((ClassifierDescriptor)originalDescriptor).getTypeConstructor());
    }

    public static boolean isSubtypeOfClass(@NotNull KotlinType type, @NotNull DeclarationDescriptor superClass) {
        if (type == null) {
            DescriptorUtils.$$$reportNull$$$0(32);
        }
        if (superClass == null) {
            DescriptorUtils.$$$reportNull$$$0(33);
        }
        if (DescriptorUtils.isSameClass(type, superClass)) {
            return true;
        }
        for (KotlinType superType : type.getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(superType, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompanionObject(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.OBJECT) && ((ClassDescriptor)descriptor).isCompanionObject();
    }

    public static boolean isSealedClass(@Nullable DeclarationDescriptor descriptor) {
        return (DescriptorUtils.isKindOf(descriptor, ClassKind.CLASS) || DescriptorUtils.isKindOf(descriptor, ClassKind.INTERFACE)) && ((ClassDescriptor)descriptor).getModality() == Modality.SEALED;
    }

    public static boolean isAnonymousObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(34);
        }
        return DescriptorUtils.isClass(descriptor) && descriptor.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isAnonymousFunction(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(35);
        }
        return descriptor instanceof SimpleFunctionDescriptor && descriptor.getName().equals(SpecialNames.ANONYMOUS);
    }

    public static boolean isNonCompanionObject(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.OBJECT) && !((ClassDescriptor)descriptor).isCompanionObject();
    }

    public static boolean isObject(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.OBJECT);
    }

    public static boolean isEnumEntry(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(36);
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ENUM_ENTRY);
    }

    public static boolean isEnumClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isInterface(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.INTERFACE);
    }

    public static boolean isClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.CLASS);
    }

    public static boolean isClassOrEnumClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isClass(descriptor) || DescriptorUtils.isEnumClass(descriptor);
    }

    private static boolean isKindOf(@Nullable DeclarationDescriptor descriptor, @NotNull ClassKind classKind) {
        if (classKind == null) {
            DescriptorUtils.$$$reportNull$$$0(37);
        }
        return descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() == classKind;
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(38);
        }
        for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope())) {
            if (!(member instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)member).getModality() != Modality.ABSTRACT) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<ClassDescriptor> getSuperclassDescriptors(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(39);
        }
        Collection<KotlinType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        ArrayList<ClassDescriptor> superClassDescriptors = new ArrayList<ClassDescriptor>();
        for (KotlinType type : superclassTypes) {
            ClassDescriptor result2 = DescriptorUtils.getClassDescriptorForType(type);
            if (KotlinBuiltIns.isAny(result2)) continue;
            superClassDescriptors.add(result2);
        }
        ArrayList<ClassDescriptor> arrayList = superClassDescriptors;
        if (arrayList == null) {
            DescriptorUtils.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    public static KotlinType getSuperClassType(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(41);
        }
        Collection<KotlinType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        for (KotlinType type : superclassTypes) {
            ClassDescriptor superClassDescriptor = DescriptorUtils.getClassDescriptorForType(type);
            if (superClassDescriptor.getKind() == ClassKind.INTERFACE) continue;
            KotlinType kotlinType = type;
            if (kotlinType == null) {
                DescriptorUtils.$$$reportNull$$$0(42);
            }
            return kotlinType;
        }
        SimpleType simpleType = DescriptorUtilsKt.getBuiltIns(classDescriptor).getAnyType();
        if (simpleType == null) {
            DescriptorUtils.$$$reportNull$$$0(43);
        }
        return simpleType;
    }

    @Nullable
    public static ClassDescriptor getSuperClassDescriptor(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(44);
        }
        Collection<KotlinType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        for (KotlinType type : superclassTypes) {
            ClassDescriptor superClassDescriptor = DescriptorUtils.getClassDescriptorForType(type);
            if (superClassDescriptor.getKind() == ClassKind.INTERFACE) continue;
            return superClassDescriptor;
        }
        return null;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForType(@NotNull KotlinType type) {
        if (type == null) {
            DescriptorUtils.$$$reportNull$$$0(45);
        }
        return DescriptorUtils.getClassDescriptorForTypeConstructor(type.getConstructor());
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(46);
        }
        ClassifierDescriptor descriptor = typeConstructor2.getDeclarationDescriptor();
        assert (descriptor instanceof ClassDescriptor) : "Classifier descriptor of a type should be of type ClassDescriptor: " + typeConstructor2;
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(47);
        }
        return classDescriptor;
    }

    @NotNull
    public static DescriptorVisibility getDefaultConstructorVisibility(@NotNull ClassDescriptor classDescriptor, boolean freedomForSealedInterfacesSupported) {
        ClassKind classKind;
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(48);
        }
        if ((classKind = classDescriptor.getKind()) == ClassKind.ENUM_CLASS || classKind.isSingleton()) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(49);
            }
            return descriptorVisibility;
        }
        if (DescriptorUtils.isSealedClass(classDescriptor)) {
            if (freedomForSealedInterfacesSupported) {
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
                if (descriptorVisibility == null) {
                    DescriptorUtils.$$$reportNull$$$0(50);
                }
                return descriptorVisibility;
            }
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(51);
            }
            return descriptorVisibility;
        }
        if (DescriptorUtils.isAnonymousObject(classDescriptor)) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.DEFAULT_VISIBILITY;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(52);
            }
            return descriptorVisibility;
        }
        assert (classKind == ClassKind.CLASS || classKind == ClassKind.INTERFACE || classKind == ClassKind.ANNOTATION_CLASS);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        if (descriptorVisibility == null) {
            DescriptorUtils.$$$reportNull$$$0(53);
        }
        return descriptorVisibility;
    }

    @Nullable
    public static ClassDescriptor getInnerClassByName(@NotNull ClassDescriptor classDescriptor, @NotNull String innerClassName, @NotNull LookupLocation location) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(54);
        }
        if (innerClassName == null) {
            DescriptorUtils.$$$reportNull$$$0(55);
        }
        if (location == null) {
            DescriptorUtils.$$$reportNull$$$0(56);
        }
        ClassifierDescriptor classifier = classDescriptor.getDefaultType().getMemberScope().getContributedClassifier(Name.identifier(innerClassName), location);
        assert (classifier instanceof ClassDescriptor) : "Inner class " + innerClassName + " in " + classDescriptor + " should be instance of ClassDescriptor, but was: " + (classifier == null ? "null" : classifier.getClass());
        return (ClassDescriptor)classifier;
    }

    @Nullable
    public static KotlinType getReceiverParameterType(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
        return receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
    }

    public static boolean isStaticNestedClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(57);
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        return descriptor instanceof ClassDescriptor && containing instanceof ClassDescriptor && !((ClassDescriptor)descriptor).isInner();
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> D unwrapFakeOverride(@NotNull D descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(58);
        }
        while (descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Collection<? extends CallableMemberDescriptor> overridden = descriptor.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor);
            }
            descriptor = overridden.iterator().next();
        }
        D d = descriptor;
        if (d == null) {
            DescriptorUtils.$$$reportNull$$$0(59);
        }
        return d;
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> D unwrapSubstitutionOverride(@NotNull D descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(60);
        }
        while (descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Collection<? extends CallableMemberDescriptor> overridden = descriptor.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor);
            }
            if (overridden.size() > 1) {
                D d = descriptor;
                if (d == null) {
                    DescriptorUtils.$$$reportNull$$$0(61);
                }
                return d;
            }
            descriptor = overridden.iterator().next();
        }
        D d = descriptor;
        if (d == null) {
            DescriptorUtils.$$$reportNull$$$0(62);
        }
        return d;
    }

    @NotNull
    public static <D extends DeclarationDescriptorWithVisibility> D unwrapFakeOverrideToAnyDeclaration(@NotNull D descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(63);
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            return (D)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor);
        }
        D d = descriptor;
        if (d == null) {
            DescriptorUtils.$$$reportNull$$$0(64);
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldRecordInitializerForProperty(@NotNull VariableDescriptor variable, @NotNull KotlinType type) {
        if (variable == null) {
            DescriptorUtils.$$$reportNull$$$0(65);
        }
        if (type == null) {
            DescriptorUtils.$$$reportNull$$$0(66);
        }
        if (variable.isVar()) return false;
        if (KotlinTypeKt.isError(type)) {
            return false;
        }
        if (TypeUtils.acceptsNullable(type)) {
            return true;
        }
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(variable);
        if (KotlinBuiltIns.isPrimitiveType(type)) return true;
        if (KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getStringType(), type)) return true;
        if (KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getNumber().getDefaultType(), type)) return true;
        if (KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getAnyType(), type)) return true;
        if (!UnsignedTypes.isUnsignedType(type)) return false;
        return true;
    }

    public static boolean classCanHaveAbstractFakeOverride(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(67);
        }
        return DescriptorUtils.classCanHaveAbstractDeclaration(classDescriptor) || classDescriptor.isExpect();
    }

    public static boolean classCanHaveAbstractDeclaration(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(68);
        }
        return classDescriptor.getModality() == Modality.ABSTRACT || DescriptorUtils.isSealedClass(classDescriptor) || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
    }

    public static boolean classCanHaveOpenMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(69);
        }
        return classDescriptor.getModality() != Modality.FINAL || classDescriptor.getKind() == ClassKind.ENUM_CLASS;
    }

    @NotNull
    public static <D extends CallableDescriptor> Set<D> getAllOverriddenDescriptors(@NotNull D f) {
        if (f == null) {
            DescriptorUtils.$$$reportNull$$$0(70);
        }
        LinkedHashSet result2 = new LinkedHashSet();
        DescriptorUtils.collectAllOverriddenDescriptors(f.getOriginal(), result2);
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            DescriptorUtils.$$$reportNull$$$0(71);
        }
        return linkedHashSet;
    }

    private static <D extends CallableDescriptor> void collectAllOverriddenDescriptors(@NotNull D current, @NotNull Set<D> result2) {
        if (current == null) {
            DescriptorUtils.$$$reportNull$$$0(72);
        }
        if (result2 == null) {
            DescriptorUtils.$$$reportNull$$$0(73);
        }
        if (result2.contains(current)) {
            return;
        }
        for (CallableDescriptor callableDescriptor : current.getOriginal().getOverriddenDescriptors()) {
            CallableDescriptor descriptor = callableDescriptor.getOriginal();
            DescriptorUtils.collectAllOverriddenDescriptors(descriptor, result2);
            result2.add(descriptor);
        }
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Set<D> getAllOverriddenDeclarations(@NotNull D memberDescriptor) {
        if (memberDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(74);
        }
        HashSet<CallableMemberDescriptor> result2 = new HashSet<CallableMemberDescriptor>();
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
                result2.add(callableMemberDescriptor);
            } else if (kind != CallableMemberDescriptor.Kind.DELEGATION && kind != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && kind != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                throw new AssertionError((Object)("Unexpected callable kind " + (Object)((Object)kind)));
            }
            result2.addAll(DescriptorUtils.getAllOverriddenDeclarations(callableMemberDescriptor));
        }
        HashSet<CallableMemberDescriptor> hashSet = result2;
        if (hashSet == null) {
            DescriptorUtils.$$$reportNull$$$0(75);
        }
        return hashSet;
    }

    public static boolean isSingletonOrAnonymousObject(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(76);
        }
        return classDescriptor.getKind().isSingleton() || DescriptorUtils.isAnonymousObject(classDescriptor);
    }

    public static boolean canHaveDeclaredConstructors(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(77);
        }
        return !DescriptorUtils.isSingletonOrAnonymousObject(classDescriptor) && !DescriptorUtils.isInterface(classDescriptor);
    }

    @Nullable
    public static String getJvmName(@NotNull Annotated annotated) {
        if (annotated == null) {
            DescriptorUtils.$$$reportNull$$$0(78);
        }
        return DescriptorUtils.getJvmName(DescriptorUtils.findJvmNameAnnotation(annotated));
    }

    @Nullable
    private static String getJvmName(@Nullable AnnotationDescriptor jvmNameAnnotation) {
        if (jvmNameAnnotation == null) {
            return null;
        }
        Map<Name, ConstantValue<?>> arguments = jvmNameAnnotation.getAllValueArguments();
        if (arguments.isEmpty()) {
            return null;
        }
        ConstantValue<?> name2 = arguments.values().iterator().next();
        if (!(name2 instanceof StringValue)) {
            return null;
        }
        return (String)((StringValue)name2).getValue();
    }

    @Nullable
    public static AnnotationDescriptor findJvmNameAnnotation(@NotNull Annotated annotated) {
        if (annotated == null) {
            DescriptorUtils.$$$reportNull$$$0(79);
        }
        return annotated.getAnnotations().findAnnotation(JVM_NAME);
    }

    public static boolean hasJvmNameAnnotation(@NotNull Annotated annotated) {
        if (annotated == null) {
            DescriptorUtils.$$$reportNull$$$0(80);
        }
        return DescriptorUtils.findJvmNameAnnotation(annotated) != null;
    }

    @NotNull
    public static SourceFile getContainingSourceFile(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(81);
        }
        if (descriptor instanceof PropertySetterDescriptor) {
            descriptor = ((PropertySetterDescriptor)descriptor).getCorrespondingProperty();
        }
        if (descriptor instanceof DeclarationDescriptorWithSource) {
            SourceFile sourceFile = ((DeclarationDescriptorWithSource)descriptor).getSource().getContainingFile();
            if (sourceFile == null) {
                DescriptorUtils.$$$reportNull$$$0(82);
            }
            return sourceFile;
        }
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        if (sourceFile == null) {
            DescriptorUtils.$$$reportNull$$$0(83);
        }
        return sourceFile;
    }

    @NotNull
    public static Collection<DeclarationDescriptor> getAllDescriptors(@NotNull MemberScope scope2) {
        if (scope2 == null) {
            DescriptorUtils.$$$reportNull$$$0(84);
        }
        Collection<DeclarationDescriptor> collection = scope2.getContributedDescriptors(DescriptorKindFilter.ALL, MemberScope.Companion.getALL_NAME_FILTER());
        if (collection == null) {
            DescriptorUtils.$$$reportNull$$$0(85);
        }
        return collection;
    }

    @NotNull
    public static FunctionDescriptor getFunctionByName(@NotNull MemberScope scope2, @NotNull Name name2) {
        FunctionDescriptor result2;
        if (scope2 == null) {
            DescriptorUtils.$$$reportNull$$$0(86);
        }
        if (name2 == null) {
            DescriptorUtils.$$$reportNull$$$0(87);
        }
        if ((result2 = DescriptorUtils.getFunctionByNameOrNull(scope2, name2)) == null) {
            throw new IllegalStateException("Function not found");
        }
        FunctionDescriptor functionDescriptor = result2;
        if (functionDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(88);
        }
        return functionDescriptor;
    }

    @Nullable
    public static FunctionDescriptor getFunctionByNameOrNull(@NotNull MemberScope scope2, @NotNull Name name2) {
        if (scope2 == null) {
            DescriptorUtils.$$$reportNull$$$0(89);
        }
        if (name2 == null) {
            DescriptorUtils.$$$reportNull$$$0(90);
        }
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : scope2.getContributedFunctions(name2, NoLookupLocation.FROM_BACKEND)) {
            if (!name2.equals(simpleFunctionDescriptor.getOriginal().getName())) continue;
            return simpleFunctionDescriptor;
        }
        return null;
    }

    @NotNull
    public static PropertyDescriptor getPropertyByName(@NotNull MemberScope scope2, @NotNull Name name2) {
        if (scope2 == null) {
            DescriptorUtils.$$$reportNull$$$0(91);
        }
        if (name2 == null) {
            DescriptorUtils.$$$reportNull$$$0(92);
        }
        for (PropertyDescriptor propertyDescriptor : scope2.getContributedVariables(name2, NoLookupLocation.FROM_BACKEND)) {
            if (!name2.equals(propertyDescriptor.getOriginal().getName())) continue;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            if (propertyDescriptor2 == null) {
                DescriptorUtils.$$$reportNull$$$0(93);
            }
            return propertyDescriptor2;
        }
        throw new IllegalStateException("Property not found");
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(94);
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty() : descriptor;
        if (callableMemberDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(95);
        }
        return callableMemberDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 71: 
            case 75: 
            case 82: 
            case 83: 
            case 85: 
            case 88: 
            case 93: 
            case 95: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 71: 
            case 75: 
            case 82: 
            case 83: 
            case 85: 
            case 88: 
            case 93: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 81: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 71: 
            case 75: 
            case 82: 
            case 83: 
            case 85: 
            case 88: 
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/DescriptorUtils";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 30: 
            case 32: 
            case 45: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classKind";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 54: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 84: 
            case 86: 
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 87: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/DescriptorUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameSafe";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameUnsafe";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameFromTopLevelClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassIdForNonLocalClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingModule";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassDescriptors";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructorVisibility";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFakeOverride";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapSubstitutionOverride";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverriddenDescriptors";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverriddenDeclarations";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingSourceFile";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionByName";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyByName";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterIfNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFqName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameSafe";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 71: 
            case 75: 
            case 82: 
            case 83: 
            case 85: 
            case 88: 
            case 93: 
            case 95: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameSafeIfPossible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameUnsafe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameFromTopLevelClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassIdForNonLocalClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOverride";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStaticDeclaration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "areInSameModule";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingModuleOrNull";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContainingModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isDirectSubclass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSameClass";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSubtypeOfClass";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousObject";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousFunction";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEnumEntry";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isKindOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasAbstractMembers";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassDescriptors";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassDescriptor";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptorForType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructorVisibility";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClassByName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isStaticNestedClass";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "unwrapFakeOverride";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSubstitutionOverride";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecordInitializerForProperty";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveAbstractFakeOverride";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveAbstractDeclaration";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveOpenMembers";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverriddenDescriptors";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "collectAllOverriddenDescriptors";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverriddenDeclarations";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isSingletonOrAnonymousObject";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDeclaredConstructors";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getJvmName";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findJvmNameAnnotation";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "hasJvmNameAnnotation";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getContainingSourceFile";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getAllDescriptors";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionByName";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionByNameOrNull";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getDirectMember";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 71: 
            case 75: 
            case 82: 
            case 83: 
            case 85: 
            case 88: 
            case 93: 
            case 95: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

