/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.ResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNodeChunk;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class XmlAttribute
implements SerializableResource {
    public static final int SIZE = 20;
    private final int namespaceIndex;
    private final int nameIndex;
    private final int rawValueIndex;
    private final ResourceValue typedValue;
    private final XmlNodeChunk parent;

    public static XmlAttribute create(ByteBuffer buffer, XmlNodeChunk parent) {
        int namespace = buffer.getInt();
        int name = buffer.getInt();
        int rawValue = buffer.getInt();
        ResourceValue typedValue = ResourceValue.create(buffer);
        return new XmlAttribute(namespace, name, rawValue, typedValue, parent);
    }

    private XmlAttribute(int namespaceIndex, int nameIndex, int rawValueIndex, ResourceValue typedValue, XmlNodeChunk parent) {
        this.namespaceIndex = namespaceIndex;
        this.nameIndex = nameIndex;
        this.rawValueIndex = rawValueIndex;
        this.typedValue = typedValue;
        this.parent = parent;
    }

    public int namespaceIndex() {
        return this.namespaceIndex;
    }

    public int nameIndex() {
        return this.nameIndex;
    }

    public int rawValueIndex() {
        return this.rawValueIndex;
    }

    public ResourceValue typedValue() {
        return this.typedValue;
    }

    public XmlNodeChunk parent() {
        return this.parent;
    }

    public final String namespace() {
        return this.getString(this.namespaceIndex());
    }

    public final String name() {
        return this.getString(this.nameIndex());
    }

    public final String rawValue() {
        return this.getString(this.rawValueIndex());
    }

    private String getString(int index) {
        return this.parent().getString(index);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.namespaceIndex());
        buffer.putInt(this.nameIndex());
        buffer.putInt(this.rawValueIndex());
        buffer.put(this.typedValue().toByteArray(shrink));
        return buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlAttribute that = (XmlAttribute)o;
        return this.namespaceIndex == that.namespaceIndex && this.nameIndex == that.nameIndex && this.rawValueIndex == that.rawValueIndex && Objects.equals(this.typedValue, that.typedValue) && Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceIndex, this.nameIndex, this.rawValueIndex, this.typedValue, this.parent);
    }

    public String toString() {
        return String.format("XmlAttribute{namespace=%s, name=%s, value=%s}", this.namespace(), this.name(), this.rawValue());
    }
}

